import os
import sys
import glob
import argparse
import math
import string
import copy as _copy
from collections import namedtuple
from operator import attrgetter
import openpyxl

import psstools
import psspy
import datetime
import xlrd
import xlwt
temp_sum = 0
WSCCArea = 15
test_index = 0 
_f, _i, _s = psspy._f, psspy._i, psspy._s

def col2num(c):
    ###"""Return number corresponding to excel-style column."""
    number=-25
    for l in c:
        if not l in string.ascii_letters:
            return False
        number+=ord(l.upper())-64+25-1
		
    return number

def checkSolution():
    try:
        solved = psspy.solved()
        return {0: "Solved", 1: "Iteration limit exceeded", 2: "Blown up", 5: "Singular Jacobian or voltage of 0.0 detected"}[solved]
    except:
        return "Failed for reason %s" % solved
		
def caseprep_Solve():
	def fdnsSolveLocked():
		psspy.progress("\n FDNS - Lock tap Lock All\n")
		psspy.fdns([0,0,0,1,0,0,99,0])
		psspy.fdns([0,0,0,1,0,0,99,0])
		# psspy.fdns([0,0,0,1,1,0,99,0])
		psspy.progress("\n FDNS - Lock tap Enable SVC Only\n")
		psspy.fdns([0,0,0,1,2,0,99,0])
		psspy.fdns([0,0,0,1,2,0,99,0])
	def fnslSolveLocked():
		psspy.progress("\n FNSL - Lock tap Lock All\n")
		psspy.fnsl([0,0,0,1,0,0,99,0])
		psspy.fnsl([0,0,0,1,0,0,99,0])
		# psspy.fnsl([0,0,0,1,1,0,99,0])
		psspy.progress("\n FNSL - Lock tap Enable SVC Only\n")
		psspy.fnsl([0,0,0,1,2,0,99,0])
		psspy.fnsl([0,0,0,1,2,0,99,0])
		
	def fnslSolve():
		psspy.progress("\n FNSL - Lock tap Enable All\n")
		psspy.fnsl([0,0,0,1,1,0,99,0])
		psspy.fnsl([0,0,0,1,1,0,99,0])
		psspy.progress("\n FNSL - Lock tap Enable SVC Only\n")
		psspy.fnsl([0,0,0,1,2,0,99,0])
		psspy.fnsl([0,0,0,1,2,0,99,0])
		
	def fdnsSolve():
		psspy.progress("\n FDNS - Lock tap Enable all shunts\n")
		psspy.fdns([0,0,0,1,1,0,99,0])
		psspy.fdns([0,0,0,1,1,0,99,0])
		psspy.progress("\n FDNS - Lock tap Enable SVC Only\n")
		psspy.fdns([0,0,0,1,2,0,99,0])
		psspy.fdns([0,0,0,1,2,0,99,0])
		
		
	psspy.save("Saved_working_case_temp.sav")
	fnslSolve()
	solved = psspy.solved()
	if solved != 0:
		psspy.case("Saved_working_case_temp.sav")
		fdnsSolve()
		solved = psspy.solved()
	if solved != 0:
		psspy.case("Saved_working_case_temp.sav")
		fnslSolveLocked()
		solved = psspy.solved()
	if solved != 0:
		psspy.case("Saved_working_case_temp.sav")
		fdnsSolveLocked()
		solved = psspy.solved()
	
	
	checkSol()
	
	
		
def Solve():
	print "======================solving========================="
	psspy.progress("\n FDNS - Lock tap lock shunts\n")
	psspy.fdns([0,0,0,1,0,0,99,0])
	psspy.fdns([0,0,0,1,0,0,99,0])
	psspy.progress("\n FDNS - Lock tap Enable SVC Only\n")
	psspy.fdns([0,0,0,1,2,0,99,0])
	psspy.fdns([0,0,0,1,2,0,99,0])
	checkSol()
	# psspy.fdns([0,0,0,1,0,0,99,0])
	# psspy.fdns([0,0,0,1,2,0,99,0])
	# psspy.fdns([0,0,0,1,1,0,99,0])
	# psspy.fnsl([0,0,0,1,1,0,99,0])
	# psspy.fnsl([0,0,0,1,1,0,99,0])
	# psspy.progress("\n FDNS - Step  tap Enable all\n")
	# psspy.fdns([1,0,0,1,1,0,99,0])
	# checkSol()
	# psspy.progress("\n FNSL - Lock tap lock shunts\n")
	# psspy.fnsl([0,0,0,1,0,0,99,0])
	# psspy.fnsl([0,0,0,1,0,0,99,0])
	# psspy.fnsl([0,0,0,1,0,0,99,0])
	# checkSol()
	# psspy.progress("\n FNSL - Stepping tap Enable All \n")
	# psspy.fnsl([1,0,0,1,1,0,99,0])
	# checkSol()
	psspy.progress("\n FNSL - Lock tap Enable All\n")
	psspy.fnsl([0,0,0,1,1,0,99,0])
	psspy.fnsl([0,0,0,1,1,0,99,0])
	checkSol()
	psspy.progress("\n FNSL - Lock tap Enable SVC Only\n")
	psspy.fnsl([0,0,0,1,2,0,99,0])
	psspy.fnsl([0,0,0,1,2,0,99,0])
	checkSol()

	

def checkSol():
	psspy.fnsl([0,0,0,1,2,0,99,0]) #### FNSL_Lock tap_ Enable SVC
	psspy.fnsl([0,0,0,1,2,0,99,0]) #### FNSL_Lock tap_ Enable SVC
	solved = psspy.solved()
	if solved == 0:
		psspy.progress("+++++++++++++++++++++++++ SOLVED PROPERLY +++++++++++++++++ \n")
		# print iterN
		return solved
	elif solved ==1 :
		return solved
	else:
		print "Not Solved"
		solvedMsg = {0: "Solved", 1: "Iteration limit exceeded", 2: "Blown up", 5: "Singular Jacobian or voltage of 0.0 detected"}[solved]
		
		load_AIES, gen_AIES, loss_total_AIES, loss_alshnt = GetSystemTotals(True)
		
		psspy.progress("+++++++++++++++++++++++++ NOT SOLVED PROPERLY +++++++++++++++++ \n")
		psspy.progress("+++++++++++++++++++++++++ NOT SOLVED PROPERLY +++++++++++++++++ \n")
		psspy.progress("+++++++++++  %s ++++++++++++ \n" %solvedMsg)
		
		raise solutionError(solvedMsg, load_AIES, gen_AIES, loss_total_AIES+loss_alshnt)

def finalcheckSol():
	psspy.progress("\n FNSL - Lock tap Enable SVC\n")
	psspy.fnsl([0,0,0,1,2,0,99,0])
	psspy.fnsl([0,0,0,1,2,0,99,0])
	solved = psspy.solved()
	if solved == 0:
		psspy.progress("+++++++++++++++++++++++++ SOLVED PROPERLY +++++++++++++++++ \n")
		# print iterN
		# return solved
	# elif solved ==1 :
		# return solved
	else:
		print "Not Solved"
		solvedMsg = {0: "Solved", 1: "Iteration limit exceeded", 2: "Blown up", 5: "Singular Jacobian or voltage of 0.0 detected"}[solved]
		load_AIES, gen_AIES, loss_total_AIES, loss_alshnt = GetSystemTotals(True)
		psspy.progress("+++++++++++++++++++++++++ NOT SOLVED PROPERLY +++++++++++++++++ \n")
		psspy.progress("+++++++++++++++++++++++++ NOT SOLVED PROPERLY +++++++++++++++++ \n")
		psspy.progress("+++++++++++  %s ++++++++++++ \n" %solvedMsg)
		
		raise solutionError(solvedMsg, load_AIES, gen_AIES, loss_total_AIES+loss_alshnt)

def defaultSolve():
	# psspy.solution_parameters_4([_i,50,_i,_i,10],[_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
	# psspy.fdns([0,0,0,1,0,0,99,0])
	# psspy.fdns([0,0,0,1,0,0,99,0])
	# psspy.fdns([0,0,0,1,0,0,99,0])
	# psspy.fdns([0,0,0,1,0,0,99,0])
	solved = 0
	iterN = 0
	while (solved == 0 or solved == 1) and iterN < 5:
		psspy.fdns([0,0,0,1,0,0,99,0])
		iterN += 1
		solved = psspy.solved()
	if solved == 0:
		print "solved " 
		print iterN
		psspy.progress("+++++++++++++++++++++++++ SOLVED PROPERLY +++++++++++++++++ \n")
		return solved
	else:
		print "Not Solved"
		solvedMsg = {0: "Solved", 1: "Iteration limit exceeded", 2: "Blown up", 5: "Singular Jacobian or voltage of 0.0 detected"}[solved]
		load_AIES, gen_AIES, loss_total_AIES, loss_alshnt = GetSystemTotals(True)
		psspy.progress("+++++++++++++++++++++++++ NOT SOLVED PROPERLY +++++++++++++++++ \n")
		psspy.progress("+++++++++++++++++++++++++ NOT SOLVED PROPERLY +++++++++++++++++ \n")
		psspy.progress("+++++++++++  %s ++++++++++++ \n" %solvedMsg)
		raise solutionError(solvedMsg, load_AIES, gen_AIES, loss_total_AIES+loss_alshnt)

class Case(object):
	flowEpsilon = 0.05
	scaleLoadsIterationLimit = 50
	includeMotors = True
	ignoreBaseCaseVoltageViolations = True
	ignoreBaseCaseBranchOverloads = True
	saskImport = 1473
	WSCCArea = 15
	marginalMW = 1
	minGenBeforeMarginal = 0.1
	ignorePmin = False
	ignorePmax = False
	swingBus = 1520
	# useIntertie = True  
	
	# def __init__(self, topologyCase, filename, intertie, MPIDs, MOList, loadData, loadMapping, tssData):
	def __init__(self, topologyCase, intertie, MPIDs, MOList, loadData, grossloaddata, loadMvarData, loadMapping, tssData, outputCaseName, month, day, year, hour, currentHourExports, Total_currentHourExports_MW):
		self.topologyCase = topologyCase
		self.outputCaseName = outputCaseName
		# self.filename = filename
		
		self.currentHourEMMO = MOList
		self.MPIDs = MPIDs
		self.loadData = loadData
		self.grossloaddata = grossloaddata
		self.loadMvarData = loadMvarData
		self.loadMapping = loadMapping
		self.tssData = tssData
		# self.emmoUpdateList = []
		self.emmoUpdateList = dict()
		self.month = month
		self.day = day
		self.year = year
		self.hour = hour
		
		self.currentHourExports = currentHourExports
		self.Total_currentHourExports_MW = Total_currentHourExports_MW
		self.currentHourImports = dict()
		
		self.P_export = dict()
		self.P_import = dict()
		self.P_netImportExport = dict()
		self.IE_flows = dict()
		self.MarginalUnitReserve = 0
		self.initial_ExportMW = 0
		self.previous_target_bctie = 0
		self.target_bctie = 0
		self.initial_btfGen_dispatched = 0
		self.btfGen_ss_net_gross = dict()
		
		
		# print len(self.currentHourEMMO)
		# for eachemmo in self.currentHourEMMO:
			# MPID = self.findMU_MPID_info(eachemmo)
			# if MPID == []:
				# self.currentHourEMMO.remove(eachemmo)
		# print len(self.currentHourEMMO)
		
		
		
		
	def findMU_MPID_info(self, eachemmo):
		MPID = []
		for eachMPID in self.MPIDs:
			if eachMPID.mpidName == eachemmo.assetName:
				MPID = eachMPID
				break
		# if MPID == []:
			# raise ValueError
		return MPID
		## -----------------------------------------------------------
	
	
	def SetSwingBus(self):
		buses, types = psspy.abusint(-1, 1, ("NUMBER", "TYPE"))
		for bus, type in zip(buses, types):
			if type == 3:
				psspy.bus_chng_3(bus, (2, ))
				break
		psspy.bus_chng_3(self.swingBus, (3, ))
		
	def GetSwingBusMW(self):
		p = 0
		try:
			psspy.inimac(self.swingBus)
			psstools.IgnoreErrorCodes = set((4,))
			while True:
				id = psspy.nxtmac(self.swingBus)
				status = psspy.macint(self.swingBus, id, 'STATUS')
				if status == 1:
					p += psspy.macdat(self.swingBus, id, 'P')
		except :
			pass
		psstools.IgnoreErrorCodes = set()
		return p
		
	def MeasureSwingBus(self):
		psstools.IgnoreErrorCodes = set((4,))
		gen = psspy.gendat(self.swingBus).real
		psstools.IgnoreErrorCodes = set()
		return 

	def UpdateMarginalUnit_caseprep(self, currentMarginalUnit, cntrl, LFMPID):
		##########Update Marginal Unit################
		############# Updated by SDR - 20Mar2019######
		##############################################
		print "---------------------------"
		print "Update Marginal Unit .... ", cntrl
		Match = False
		tag = "Unavailable"
		
		target_bctie = 0
		update_target_bcie = 'False'
		
		if cntrl == 'NEXT':
			for GSOUnit in self.currentHourEMMO:      
				# print "Hello" , GSOUnit.gsoMPID, GSOUnit.gsoNumber
				if not Match:
					if GSOUnit.serial == currentMarginalUnit.serial:
						Match = True
					continue
				else :
					# if GSOUnit.assetName == 'BCHIMP' or GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
					if GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
						continue
					
					# print "GSOUnit.gsoNumber - mpid", GSOUnit.gsoNumber , GSOUnit.gsoMPID
					tag = "Found"
					print "---Return Update MU-----"
					return GSOUnit 
					break
				
		elif cntrl == 'PREV':
			for GSOUnit in reversed(self.currentHourEMMO):    
					
				if not Match:
					if GSOUnit.serial == currentMarginalUnit.serial:
						Match = True
					continue
				else :
					# if GSOUnit.assetName == 'BCHIMP' or GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
					if GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
						continue
					
					# print "GSOUnit.gsoNumber - mpid", GSOUnit.gsoNumber , GSOUnit.gsoMPID
					
					tag = "Found"
					print "---Return Update MU-----"
					return GSOUnit 
					break			
		if tag == "Unavailable":
			load_AIES, gen_AIES, loss_total_AIES, loss_alshnt = GetSystemTotals(True)
			raise InsufficientSourceError(load_AIES, gen_AIES, loss_total_AIES+loss_alshnt, "UpdateMarginalUnit_caseprep")
					
	
	def sask_imp_adjustment_V0(control, MPID):
		########## NOT REQUIRED .....
		############# Updated by SDR - 20Mar2019
		
		if control == 'Initialize':
			saskbus = 1473
			# psspy.plant_data(saskbus,0,[ 1.0, 100.0])
			# psspy.machine_data_2(saskbus,r"""3""",[_i,2,_i,_i,_i,_i],[ 0.0398,-0.3269, 1605.6,-1170.3, 2641.0,-87991.2, 1870.9, 0.12, 0.24,_f,_f,_f,_f,_f,_f,_f,_f])
			# psspy.seq_machine_data_3(saskbus,r"""3""",_i,[ 0.12, 0.24, 0.12, 0.24, 0.12, 0.24, 0.24, 0.24,_f,_f])
			status = 1
			psspy.machine_chng_2(saskbus,r"""3""",[status,_i,_i,_i,_i,_i],[0.0,0.0,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
			err, busvoltage = psspy.busdat(saskbus, 'PU')
			psspy.plant_chng(saskbus,_i,[busvoltage,_f])
		elif control == 'Finalize':
			totalPgen = 0
			totalQgen = 0
			for gen in MPID.generators:
				err, [pgen, qgen] = psspy.macdat(gen.bus, gen.id, ['P', 'Q'])
				err, [status] = psspy.macdat(gen.bus, gen.id, ['STATUS'])
				if status != 0 :
					totalPgen += pgen 
					totalQgen += qgen
			mismatch = totalPgen - 0
			while abs(mismatch) > flowTolerance:
				totalPload, totalQload = determineMPID_Load()
				PL = totalPgen - totalPload
				QL = totalQgen - totalQload
				for load in MPID.loads:
					psspy.load_chng_4(load.bus,load.id,[1,_i,_i,_i,_i,_i],[PL,QL,_f,_f,_f,_f])
				for gen in MPID.generators:
					psspy.machine_chng_2(gen.bus,gen.id,[_i,_i,_i,_i,_i,_i],[0.0,0.0,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
				Solve()
				totalPgen = 0
				totalQgen = 0
				for gen in MPID.generators:
					err, [pgen, qgen] = psspy.macdat(gen.bus, gen.id, ['P', 'Q'])
					err, [status] = psspy.macdat(gen.bus, gen.id, ['STATUS'])
					if status != 0 :
						totalPgen += pgen 
						totalQgen += qgen
				mismatch = totalPgen - 0
					
					
	
	def ProcessMPID(self, setPGen=None):
		########## Process Data and Create Initial State (S-1) Case .....
		############# Updated by SDR - 20Mar2019
		print "======================================================="
		print "Process Data and Create Initial State (S-1) Case ....."
		print "--------------------------------------------------------"
		
		def UpdateWorkingMPID_V0(delta, workingMPID, control, fulldispatchamount=None):
			delta = abs(delta)
			MPID = workingMPID
			print MPID.mpidName
			if control == "Reduce":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print "pgen  : ", pgen
					if status != 0 :
						if delta>pgen:
							newpgen = 0
							newstatus = 0
							delta = delta - pgen
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
						elif delta<pgen:
							newpgen = pgen - delta
							delta = 0
							newstatus  = 1
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
						elif delta == pgen:
							newpgen = 0
							delta = 0
							newstatus = 0
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
			elif control == "Increase":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
					# raw_input()
					print delta
					if pgen < pmax:
						if (delta+pgen) > pmax:
							newpgen = pmax
							newstatus = 1
							delta = delta - (pmax - pgen)
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							
						else: ## delta < pmax
							newpgen = pgen + delta
							delta = 0
							newstatus = 1 
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							break
					else:
						continue
				if delta != 0 :
					print delta
					# raw_input("Could not dispatch all")
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
						if status != 0:
							newstatus = 1
							UpdateGen_Max(gen.bus, gen.id, pgen+delta, pgen+delta, newstatus)
							break
					
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				temp = 0
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax
					temp = temp + pgen
				print temp
				# raw_input()
					
			elif control == "SwitchOff":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					newpgen = 0
					newstatus = 0 
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
			elif control == "Full Dispatch":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					newpgen = pmax
					newstatus = 1
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
				totalPgen, totalPmax = determineMPID_Gen(MPID)
				print totalPgen, totalPmax
				# raw_input()
				if fulldispatchamount != totalPgen:
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					extra = fulldispatchamount - totalPgen
					print extra
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						newpgen = pmax
						newstatus = 1
						UpdateGen_Max(gen.bus, gen.id, pmax+extra, pmax+extra, newstatus)
		
		
		def UpdateWorkingMPID_v1(delta, workingMPID, control, fulldispatchamount=None):
			delta = abs(delta)
			MPID = workingMPID
			print MPID.mpidName
			if control == "Reduce":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print "pgen  : ", pgen
					if status != 0 :
						if delta>pgen:
							if MPID.mpidName == "120SIMP":
								newpgen = pgen - delta
								newstatus = 1
								delta = 0
								UpdateGen(gen.bus, gen.id, newpgen, newstatus)
								# raw_input("=====").
								print "delta :", delta
							else:
								newpgen = 0
								newstatus = 0
								delta = delta - pgen
								UpdateGen(gen.bus, gen.id, newpgen, newstatus)
								# raw_input("=====")
								print "delta :", delta
							# raw_input()
						elif delta<pgen:
							newpgen = pgen - delta
							delta = 0
							newstatus  = 1
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
						elif delta == pgen:
							newpgen = 0
							delta = 0
							newstatus = 0
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
					if status == 0 and MPID.mpidName == "120SIMP":
						if delta>pgen:
							newpgen = pgen - delta
							newstatus = 1
							delta = 0
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====").
							print "delta :", delta
			elif control == "Increase":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
					# raw_input()
					print delta
					if pgen < pmax:
						if (delta+pgen) > pmax:
							newpgen = pmax
							newstatus = 1
							delta = delta - (pmax - pgen)
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							
						else: ## delta < pmax
							newpgen = pgen + delta
							delta = 0
							newstatus = 1 
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							break
					else:
						continue
				if delta != 0 :
					print delta
					# raw_input("Could not dispatch all")
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
						if status != 0:
							newstatus = 1
							UpdateGen_Max(gen.bus, gen.id, pgen+delta, pgen+delta, newstatus)
							break
					
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				temp = 0
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax
					temp = temp + pgen
				print temp
				# raw_input()
					
			elif control == "SwitchOff":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					newpgen = 0
					newstatus = 0 
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
			elif control == "Full Dispatch":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					newpgen = pmax
					newstatus = 1
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
				totalPgen, totalPmax = determineMPID_Gen(MPID)
				print totalPgen, totalPmax
				# raw_input()
				if fulldispatchamount != totalPgen:
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					extra = fulldispatchamount - totalPgen
					print extra
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						newpgen = pmax
						newstatus = 1
						UpdateGen_Max(gen.bus, gen.id, pmax+extra, pmax+extra, newstatus)
		
		def UpdateWorkingMPID_v2(delta, workingMPID, control, fulldispatchamount=None):
			########## Update Working MPID Generation.....
			############# Updated by SDR - 20Mar2019
			print "--------------------------------------------"
			print "Updating Working MPID ....... "
			print "Control Mode : ", control
			print "Delta : ", delta
			
			
			
			delta = abs(delta)
			MPID = workingMPID
			print MPID.mpidName
			if control == "Reduce":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print "pgen  : ", pgen
					if status == 0 :
						raise 
					else:
					# if status != 0 :
						if delta>pgen:
							newpgen = 0
							newstatus = 1
							delta = delta - pgen
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							# raw_input()
						elif delta<pgen:
							newpgen = pgen - delta
							delta = 0
							newstatus  = 1
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
						elif delta == pgen:
							newpgen = 0
							delta = 0
							newstatus = 1
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
			elif control == "Increase":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
					# raw_input()
					print delta
					if status == 0 :
						raise "Gen Turned Off.....!!!!!!!!!!!!!"
					if pgen < pmax:
						if (delta+pgen) > pmax:
							newpgen = pmax
							newstatus = 1
							delta = delta - (pmax - pgen)
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							
						else: ## delta < pmax
							newpgen = pgen + delta
							delta = 0
							newstatus = 1 
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							break
					else:
						continue
				if delta != 0 :
					print delta
					# raw_input("Could not dispatch all")
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
						if status != 0:
							newstatus = 1
							UpdateGen_Max(gen.bus, gen.id, pgen+delta, pgen+delta, newstatus)
							break
					
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				temp = 0
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax
					temp = temp + pgen
				print temp
				# raw_input()
			
			elif control == "Increase Load":
				if len(MPID.loadmpids) > 0:
					for loadmpid in MPID.loadmpids:
						loads = MPID.onsiteLoads[loadmpid]
						# mwData = getLoadMWData(loadmpid, dataToUse) * MPID.loadDistributionFactor
						mwData = delta /len(MPID.loadmpids)
						
						print "==============================="
						print loadmpid, mwData
						
						for load in loads:
							
							loadbus = int(load.split("-")[0])
							loadid = load.split("-")[1]
							status, pload, qload = getLoadData(loadbus, loadid)
							
							del_pload = mwData/len(loads)
							pf = 0.9
							del_qload = del_pload * math.tan(math.acos(pf)) 
							
							if pload != 0:
								status = 1
							else:
								status = 0
							
							
							print (loadbus, loadid, status, pload+del_pload, qload+del_qload)
							
							psspy.progress ("\n %s, %s, %s, %s, %s\n" %(loadbus, loadid, status, pload+del_pload, qload+del_qload))
							psspy.progress("\n Updating Load...\n")
							
							UpdateLoad(loadbus, loadid, status, pload+del_pload, qload+del_qload)						
			
			elif control == "Reduce Load":
				if len(MPID.loadmpids) > 0:
					for loadmpid in MPID.loadmpids:
						loads = MPID.onsiteLoads[loadmpid]
						# mwData = getLoadMWData(loadmpid, dataToUse) * MPID.loadDistributionFactor
						mwData = delta/len(MPID.loadmpids)
						
						print "==============================="
						print loadmpid, mwData
						
						for load in loads:
							
							loadbus = int(load.split("-")[0])
							loadid = load.split("-")[1]
							status, pload, qload = getLoadData(loadbus, loadid)
							
							del_pload = mwData/len(loads)
							pf = 0.9
							del_qload = del_pload * math.tan(math.acos(pf)) 
							
							if pload != 0:
								status = 1
							else:
								status = 0
							
							print (loadbus, loadid, status, pload-del_pload, qload-del_qload)
							
							psspy.progress ("\n %s, %s, %s, %s, %s\n" %(loadbus, loadid, status, pload-del_pload, qload-del_qload))
							psspy.progress("\n Updating Load...\n")
							
							UpdateLoad(loadbus, loadid, status, pload-del_pload, qload-del_qload)						
				
				

			
			elif control == "SwitchOff":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					newpgen = 0
					newstatus = 0 
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
			elif control == "Full Dispatch":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					newpgen = pmax
					newstatus = 1
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
				totalPgen, totalPmax = determineMPID_Gen(MPID)
				print totalPgen, totalPmax
				# raw_input()
				if fulldispatchamount != totalPgen:
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					extra = fulldispatchamount - totalPgen
					print extra
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						newpgen = pmax
						newstatus = 1
						UpdateGen_Max(gen.bus, gen.id, pmax+extra, pmax+extra, newstatus)
			
			print "---------------------Return-------"
		
		def UpdateWorkingMPID(delta, workingMPID, control, fulldispatchamount=None):
			########## Update Working MPID Generation.....
			############# Updated by SDR - 20Mar2019
			print "--------------------------------------------"
			print "Updating Working MPID ....... "
			print "Control Mode : ", control
			print "Delta : ", delta
			
			
			
			delta = abs(delta)
			MPID = workingMPID
			print MPID.mpidName
			if control == "Reduce":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print "pgen  : ", pgen
					if status == 0 :
						raise 
					else:
					# if status != 0 :
						if delta>pgen:
							newpgen = 0
							newstatus = 1
							delta = delta - pgen
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							# raw_input()
						elif delta<pgen:
							newpgen = pgen - delta
							delta = 0
							newstatus  = 1
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
						elif delta == pgen:
							newpgen = 0
							delta = 0
							newstatus = 1
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
			elif control == "Increase":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
					# raw_input()
					print delta
					if status == 0 :
						raise "Gen Turned Off.....!!!!!!!!!!!!!"
					if pgen < pmax:
						if (delta+pgen) > pmax:
							newpgen = pmax
							newstatus = 1
							delta = delta - (pmax - pgen)
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							
						else: ## delta < pmax
							newpgen = pgen + delta
							delta = 0
							newstatus = 1 
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							break
					else:
						continue
				if delta != 0 :
					print delta
					# raw_input("Could not dispatch all")
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
						if status != 0:
							newstatus = 1
							UpdateGen_Max(gen.bus, gen.id, pgen+delta, pgen+delta, newstatus)
							break
					
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				temp = 0
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax
					temp = temp + pgen
				print temp
				# raw_input()
			
			elif control == "Increase Load":
				if len(MPID.loadmpids) > 0:
					for loadmpid in MPID.loadmpids:
						loads = MPID.onsiteLoads[loadmpid]
						# mwData = getLoadMWData(loadmpid, dataToUse) * MPID.loadDistributionFactor
						mwData = delta /len(MPID.loadmpids)
						
						print "==============================="
						print loadmpid, mwData
						
						for load in loads:
							
							loadbus = int(load.split("-")[0])
							loadid = load.split("-")[1]
							status, pload, qload = getLoadData(loadbus, loadid)
							
							del_pload = mwData/len(loads)
							pf = 0.9
							del_qload = del_pload * math.tan(math.acos(pf)) 
							
							if pload != 0:
								status = 1
							else:
								status = 0
							
							
							print (loadbus, loadid, status, pload+del_pload, qload+del_qload)
							
							psspy.progress ("\n %s, %s, %s, %s, %s\n" %(loadbus, loadid, status, pload+del_pload, qload+del_qload))
							psspy.progress("\n Updating Load...\n")
							
							UpdateLoad(loadbus, loadid, status, pload+del_pload, qload+del_qload)						
			
			elif control == "Reduce Load":
				if len(MPID.loadmpids) > 0:
					for loadmpid in MPID.loadmpids:
						loads = MPID.onsiteLoads[loadmpid]
						# mwData = getLoadMWData(loadmpid, dataToUse) * MPID.loadDistributionFactor
						mwData = delta/len(MPID.loadmpids)
						
						print "==============================="
						print loadmpid, mwData
						
						for load in loads:
							
							loadbus = int(load.split("-")[0])
							loadid = load.split("-")[1]
							status, pload, qload = getLoadData(loadbus, loadid)
							
							del_pload = mwData/len(loads)
							pf = 0.9
							del_qload = del_pload * math.tan(math.acos(pf)) 
							
							if pload != 0:
								status = 1
							else:
								status = 0
							
							print (loadbus, loadid, status, pload-del_pload, qload-del_qload)
							
							psspy.progress ("\n %s, %s, %s, %s, %s\n" %(loadbus, loadid, status, pload-del_pload, qload-del_qload))
							psspy.progress("\n Updating Load...\n")
							
							UpdateLoad(loadbus, loadid, status, pload-del_pload, qload-del_qload)						
				
				

			
			elif control == "SwitchOff":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					newpgen = 0
					newstatus = 0 
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
			elif control == "Full Dispatch":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					newpgen = pmax
					newstatus = 1
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
				totalPgen, totalPmax = determineMPID_Gen(MPID)
				print totalPgen, totalPmax
				# raw_input()
				if fulldispatchamount != totalPgen:
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					extra = fulldispatchamount - totalPgen
					print extra
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						newpgen = pmax
						newstatus = 1
						UpdateGen_Max(gen.bus, gen.id, pmax+extra, pmax+extra, newstatus)
			
			print "---------------------Return-------"
		
		def findMarginalUnit_MPID_info(MarginalUnit):
			########## Extract Marginal Unit Info .....
			############# Updated by SDR - 20Mar2019
			MPID = []
			for eachMPID in self.MPIDs:
				if eachMPID.mpidName == MarginalUnit.assetName:
					MPID = eachMPID
					break
			# if MPID == []:
				# raise ValueError
			return MPID
			
		
			
		def UpdateSystem_v0(deltaNetFlow, MarginalUnit, control, LFMPID):
			########## Update System Generation .....
			############# Updated by SDR - 20Mar2019
			print "====================Update System+++++++++++++++++++++++++++++++"
			
			MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
			print "MU : ", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber, MarginalUnit.assetShortName
			print "MarginalUnitReserve ", MarginalUnitReserve
			print "control : ", control
			print "........................................."
			
			if MarginalUnit.relatedImportAsset == bc_imp:
				# desiredSwingBus = assignSwingBus(MarginalUnit)
				target_bctie = MarginalUnit.P_netImportExport_dict[bc]
				minimum_bctie_blockValue = MarginalUnit.availablePower
				previous_target_bctie = MarginalUnit.P_prev_netImportExport_dict[bc]
				caseprep_Solve()
				current_bctie = TieMeasure()
				print target_bctie, previous_target_bctie, current_bctie
				# raw_input("=====Check=====")
				if current_bctie > target_bctie:
					mismatch = abs(current_bctie - target_bctie)
					print "mismatch : ", mismatch
					MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", LFMPID)
					MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
					MarginalUnit = UpdateSystem(mismatch, MarginalUnit, "Increase", LFMPID)
					caseprep_Solve()
					current_bctie = TieMeasure()
					
					mismatch = abs(current_bctie - target_bctie)
					print "MU : ", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber
					print "MarginalUnitReserve :", MarginalUnitReserve
					print "current_bctie :", current_bctie
					print "mismatch :", mismatch
				elif current_bctie <= previous_target_bctie:
					mismatch = abs(current_bctie - previous_target_bctie)
					print "mismatch : ", mismatch
					MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
					MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
					MarginalUnit = UpdateSystem(mismatch, MarginalUnit, "Reduce", LFMPID)
					caseprep_Solve()
					current_bctie = TieMeasure()
					mismatch = abs(current_bctie - previous_target_bctie)
					print "MU : ", MarginalUnit.assetName, MarginalUnit.blockNumber
					print "MarginalUnitReserve :", MarginalUnitReserve
					print "current_bctie :", current_bctie
					print "mismatch :", mismatch
				elif current_bctie <= target_bctie and current_bctie > previous_target_bctie:
					MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
					print "MU : ", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber
					print "MarginalUnitReserve :", MarginalUnitReserve
					print "current_bctie :", current_bctie
					# raw_input()
			elif MarginalUnit.relatedImportAsset == sk_imp:
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				# saskbus = 1473
				# saskImploadid = '34'
				delta = abs(deltaNetFlow)
				target_sasktie = MarginalUnit.P_netImportExport_dict[sk]
				previous_target_sasktie = MarginalUnit.P_prev_netImportExport_dict[sk]
				minimum_sasktie_blockValue = MarginalUnit.availablePower
				current_sasktie, temp = determineMPID_Gen(MPID)
				
				if control == "Increase":
					final_sasktie = current_sasktie + delta
										
					if final_sasktie >= target_sasktie:
						status = 1
						setSk_Tie(target_sasktie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-target_sasktie, _f, _f,_f,_f,_f)  )
						# MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", "")
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", LFMPID)
						delta = final_sasktie - target_sasktie
					elif final_sasktie < target_sasktie and final_sasktie >= previous_target_sasktie:
						status = 1
						setSk_Tie(final_sasktie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-final_sasktie, _f, _f,_f,_f,_f)  )
						delta = 0
					
				elif control == "Reduce":
					final_sasktie = current_sasktie - delta	
					if final_sasktie < target_sasktie and final_sasktie >= previous_target_sasktie:
						status = 1
						setSk_Tie(final_sasktie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-final_sasktie, _f, _f,_f,_f,_f))
						delta = 0
					elif final_sasktie < previous_target_sasktie:
						status = 0
						setSk_Tie(previous_target_sasktie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-previous_target_sasktie, _f, _f,_f,_f,_f))
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
						delta = previous_target_sasktie - final_sasktie
			elif MarginalUnit.relatedImportAsset == mt_imp:
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				delta = abs(deltaNetFlow)
				target_mtTie = MarginalUnit.P_netImportExport_dict[mt]
				previous_target_mtTie = MarginalUnit.P_prev_netImportExport_dict[mt]
				# minimum_sasktie_blockValue = MarginalUnit.availablePower
				current_mtTie, temp = determineMPID_Gen(MPID)
				
				if control == "Increase":
					final_mtTie = current_mtTie + delta
										
					if final_mtTie >= target_mtTie:
						status = 1
						setMT_Tie(target_mtTie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-target_mtTie, _f, _f,_f,_f,_f)  )
						# MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", "")
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", LFMPID)
						delta = final_mtTie - target_mtTie
					elif final_mtTie < target_mtTie and final_mtTie >= previous_target_mtTie:
						status = 1
						setMT_Tie(final_mtTie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-final_mtTie, _f, _f,_f,_f,_f)  )
						delta = 0
					
				elif control == "Reduce":
					final_mtTie = current_mtTie - delta	
					if final_mtTie < target_mtTie and final_mtTie >= previous_target_mtTie:
						status = 1
						setMT_Tie(final_mtTie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-final_mtTie, _f, _f,_f,_f,_f))
						delta = 0
					elif final_mtTie < previous_target_mtTie:
						status = 0
						setMT_Tie(previous_target_mtTie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-previous_target_mtTie, _f, _f,_f,_f,_f))
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
						delta = previous_target_mtTie - final_mtTie	
			else:
				if control == "Increase":
				# if deltaNetFlow<0:  #### Working MPID Gen was reduced to nullify the netFlow - Increase Total Gen Dispatch
					delta = abs(deltaNetFlow)
					for mUnit in self.currentHourEMMO:
						if mUnit.serial == MarginalUnit.serial:
							MU_MPID = findMarginalUnit_MPID_info(MarginalUnit)
							MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
							if delta > MarginalUnitReserve:
								print "delta ", delta
								# raw_input()
								if mUnit.reduceLoadTag.upper() == 'YES' and mUnit.finalNTGLoad > 0:
									UpdateWorkingMPID(mUnit.finalNTGLoad, MU_MPID, "Reduce Load")
									MarginalUnitReserve = MarginalUnitReserve - mUnit.finalNTGLoad
									mUnit.finalNTGLoad = 0
									UpdateWorkingMPID(MarginalUnitReserve, MU_MPID, "Increase")
								else:
									UpdateWorkingMPID(MarginalUnitReserve, MU_MPID, "Increase")
								delta = delta - MarginalUnitReserve
								# MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "NEXT", LFMPID)
								MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", LFMPID)
								MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
								# MarginalUnitReserve = MarginalUnit.availablePower
								continue
							elif delta <= MarginalUnitReserve:
								print "delta ", delta
								# raw_input()
								if mUnit.reduceLoadTag.upper() == 'YES' and mUnit.finalNTGLoad > 0:
									if delta > mUnit.finalNTGLoad:
										UpdateWorkingMPID(mUnit.finalNTGLoad, MU_MPID, "Reduce Load")
										delta = delta - mUnit.finalNTGLoad
										mUnit.finalNTGLoad = 0
										UpdateWorkingMPID(delta, MU_MPID, "Increase")
										delta = 0
									else:
										UpdateWorkingMPID(delta, MU_MPID, "Reduce Load")
										delta = 0
								else:
									UpdateWorkingMPID(delta, MU_MPID, "Increase")
								MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
								break
				elif control == "Reduce":
				# elif deltaNetFlow>0:  #### Working MPID Ges was reduced to nullify the netFlow - Increase Total Gen Dispatch
					delta = abs(deltaNetFlow)
					for mUnit in self.currentHourEMMO:
						if mUnit.serial == MarginalUnit.serial:
							MU_MPID = findMarginalUnit_MPID_info(MarginalUnit)
							MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
							Pdisp = mUnit.availablePower - MarginalUnitReserve
							if mUnit.reduceLoadTag.upper() == 'YES':
								reducedLoad = mUnit.deductibleNTGLoad - mUnit.finalNTGLoad
								if mUnit.finalNTGLoad >= 0 and Pdisp <= 0:
									if delta <= reducedLoad:
										UpdateWorkingMPID(delta, MU_MPID, "Increase Load")
										mUnit.finalNTGLoad = mUnit.finalNTGLoad + delta
										MarginalUnitReserve = MarginalUnitReserve + delta
										delta = 0
										break
									else:
										UpdateWorkingMPID(reducedLoad, MU_MPID, "Increase Load")
										mUnit.finalNTGLoad = mUnit.finalNTGLoad + reducedLoad
										MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
										MarginalUnitReserve = 0
										delta = delta - reducedLoad
										continue
								elif mUnit.finalNTGLoad == 0 and Pdisp > 0:
									if delta <= Pdisp:
										UpdateWorkingMPID(delta, MU_MPID, "Reduce")
										MarginalUnitReserve = MarginalUnitReserve + delta
										delta = 0
										break
									else:  ##delta > Pdisp:
										UpdateWorkingMPID(Pdisp, MU_MPID, "Reduce")
										MarginalUnitReserve = MarginalUnitReserve + Pdisp
										delta = delta - Pdisp
										if delta >= reducedLoad:
											UpdateWorkingMPID(reducedLoad, MU_MPID, "Increase Load")
											mUnit.finalNTGLoad = mUnit.finalNTGLoad + reducedLoad
											MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
											delta = delta - reducedLoad
											continue
										else: ## delta < reducedLoad:
											UpdateWorkingMPID(delta, MU_MPID, "Increase Load")
											mUnit.finalNTGLoad = mUnit.finalNTGLoad + delta
											MarginalUnitReserve = MarginalUnitReserve + delta
											delta = 0
											break
							else:
								print "Pdisp :", Pdisp
								# raw_input()
								if delta > Pdisp:
									UpdateWorkingMPID(Pdisp, MU_MPID, "Reduce")
									delta = delta - Pdisp
									MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
									MarginalUnitReserve = 0
									continue
								else: ## delta <= Pdisp:
									UpdateWorkingMPID(delta, MU_MPID, "Reduce")
									MarginalUnitReserve = MarginalUnitReserve + delta
									delta = 0
									# raw_input("=====")
									print "delta :", delta
									break
			print "============================Return From Update System-----------"
			return MarginalUnit
			
		def UpdateSystem(deltaNetFlow, MarginalUnit, control, LFMPID):
			########## Update System Generation .....
			############# Updated by SDR - 20Mar2019
			print "====================Update System+++++++++++++++++++++++++++++++"
			
			MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
			print "MU : ", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber, MarginalUnit.assetShortName
			print "MarginalUnitReserve ", MarginalUnitReserve
			print "control : ", control
			print "........................................."
			
			if MarginalUnit.relatedImportAsset == bc_imp:
				# desiredSwingBus = assignSwingBus(MarginalUnit)
				target_bctie = MarginalUnit.P_netImportExport_dict[bc]
				minimum_bctie_blockValue = MarginalUnit.availablePower
				previous_target_bctie = MarginalUnit.P_prev_netImportExport_dict[bc]
				caseprep_Solve()
				current_bctie = TieMeasure()
				print target_bctie, previous_target_bctie, current_bctie
				# raw_input("=====Check=====")
				if current_bctie > target_bctie:
					mismatch = abs(current_bctie - target_bctie)
					print "mismatch : ", mismatch
					MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", LFMPID)
					MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
					MarginalUnit = UpdateSystem(mismatch, MarginalUnit, "Increase", LFMPID)
					caseprep_Solve()
					current_bctie = TieMeasure()
					
					mismatch = abs(current_bctie - target_bctie)
					print "MU : ", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber
					print "MarginalUnitReserve :", MarginalUnitReserve
					print "current_bctie :", current_bctie
					print "mismatch :", mismatch
				elif current_bctie <= previous_target_bctie:
					mismatch = abs(current_bctie - previous_target_bctie)
					print "mismatch : ", mismatch
					MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
					MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
					MarginalUnit = UpdateSystem(mismatch, MarginalUnit, "Reduce", LFMPID)
					caseprep_Solve()
					current_bctie = TieMeasure()
					mismatch = abs(current_bctie - previous_target_bctie)
					print "MU : ", MarginalUnit.assetName, MarginalUnit.blockNumber
					print "MarginalUnitReserve :", MarginalUnitReserve
					print "current_bctie :", current_bctie
					print "mismatch :", mismatch
				elif current_bctie <= target_bctie and current_bctie > previous_target_bctie:
					MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
					print "MU : ", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber
					print "MarginalUnitReserve :", MarginalUnitReserve
					print "current_bctie :", current_bctie
					# raw_input()
			elif MarginalUnit.relatedImportAsset == sk_imp:
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				# saskbus = 1473
				# saskImploadid = '34'
				delta = abs(deltaNetFlow)
				target_sasktie = MarginalUnit.P_netImportExport_dict[sk]
				previous_target_sasktie = MarginalUnit.P_prev_netImportExport_dict[sk]
				minimum_sasktie_blockValue = MarginalUnit.availablePower
				current_sasktie, temp = determineMPID_Gen(MPID)
				
				if control == "Increase":
					final_sasktie = current_sasktie + delta
										
					if final_sasktie >= target_sasktie:
						status = 1
						setSk_Tie(target_sasktie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-target_sasktie, _f, _f,_f,_f,_f)  )
						# MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", "")
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", LFMPID)
						delta = final_sasktie - target_sasktie
					elif final_sasktie < target_sasktie and final_sasktie >= previous_target_sasktie:
						status = 1
						setSk_Tie(final_sasktie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-final_sasktie, _f, _f,_f,_f,_f)  )
						delta = 0
					
				elif control == "Reduce":
					final_sasktie = current_sasktie - delta	
					if final_sasktie < target_sasktie and final_sasktie >= previous_target_sasktie:
						status = 1
						setSk_Tie(final_sasktie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-final_sasktie, _f, _f,_f,_f,_f))
						delta = 0
					elif final_sasktie < previous_target_sasktie:
						status = 0
						setSk_Tie(previous_target_sasktie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-previous_target_sasktie, _f, _f,_f,_f,_f))
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
						delta = previous_target_sasktie - final_sasktie
			elif MarginalUnit.relatedImportAsset == mt_imp:
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				delta = abs(deltaNetFlow)
				target_mtTie = MarginalUnit.P_netImportExport_dict[mt]
				previous_target_mtTie = MarginalUnit.P_prev_netImportExport_dict[mt]
				# minimum_sasktie_blockValue = MarginalUnit.availablePower
				current_mtTie, temp = determineMPID_Gen(MPID)
				
				if control == "Increase":
					final_mtTie = current_mtTie + delta
										
					if final_mtTie >= target_mtTie:
						status = 1
						setMT_Tie(target_mtTie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-target_mtTie, _f, _f,_f,_f,_f)  )
						# MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", "")
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", LFMPID)
						delta = final_mtTie - target_mtTie
					elif final_mtTie < target_mtTie and final_mtTie >= previous_target_mtTie:
						status = 1
						setMT_Tie(final_mtTie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-final_mtTie, _f, _f,_f,_f,_f)  )
						delta = 0
					
				elif control == "Reduce":
					final_mtTie = current_mtTie - delta	
					if final_mtTie < target_mtTie and final_mtTie >= previous_target_mtTie:
						status = 1
						setMT_Tie(final_mtTie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-final_mtTie, _f, _f,_f,_f,_f))
						delta = 0
					elif final_mtTie < previous_target_mtTie:
						status = 0
						setMT_Tie(previous_target_mtTie)
						# err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-previous_target_mtTie, _f, _f,_f,_f,_f))
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
						delta = previous_target_mtTie - final_mtTie	
			else:
				if control == "Increase":
				# if deltaNetFlow<0:  #### Working MPID Gen was reduced to nullify the netFlow - Increase Total Gen Dispatch
					delta = abs(deltaNetFlow)
					for mUnit in self.currentHourEMMO:
						if mUnit.serial == MarginalUnit.serial:
							MU_MPID = findMarginalUnit_MPID_info(MarginalUnit)
							MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
							if delta > MarginalUnitReserve:
								print "delta ", delta
								# raw_input()
								if mUnit.reduceLoadTag.upper() == 'YES' and mUnit.finalNTGLoad > 0:
									UpdateWorkingMPID(mUnit.finalNTGLoad, MU_MPID, "Reduce Load")
									MarginalUnitReserve = MarginalUnitReserve - mUnit.finalNTGLoad
									mUnit.finalNTGLoad = 0
									UpdateWorkingMPID(MarginalUnitReserve, MU_MPID, "Increase")
								else:
									UpdateWorkingMPID(MarginalUnitReserve, MU_MPID, "Increase")
								
								delta = delta - MarginalUnitReserve
								MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", LFMPID)
								MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
								MarginalUnit = UpdateSystem(delta, MarginalUnit, "Increase", LFMPID)
								break
							elif delta <= MarginalUnitReserve:
								print "delta ", delta
								# raw_input()
								if mUnit.reduceLoadTag.upper() == 'YES' and mUnit.finalNTGLoad > 0:
									if delta > mUnit.finalNTGLoad:
										UpdateWorkingMPID(mUnit.finalNTGLoad, MU_MPID, "Reduce Load")
										delta = delta - mUnit.finalNTGLoad
										mUnit.finalNTGLoad = 0
										UpdateWorkingMPID(delta, MU_MPID, "Increase")
										delta = 0
									else:
										UpdateWorkingMPID(delta, MU_MPID, "Reduce Load")
										delta = 0
								else:
									UpdateWorkingMPID(delta, MU_MPID, "Increase")
								MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
								break
				elif control == "Reduce":
				# elif deltaNetFlow>0:  #### Working MPID Ges was reduced to nullify the netFlow - Increase Total Gen Dispatch
					delta = abs(deltaNetFlow)
					for mUnit in self.currentHourEMMO:
						if mUnit.serial == MarginalUnit.serial:
							MU_MPID = findMarginalUnit_MPID_info(MarginalUnit)
							MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
							Pdisp = mUnit.availablePower - MarginalUnitReserve
							if mUnit.reduceLoadTag.upper() == 'YES':
								reducedLoad = mUnit.deductibleNTGLoad - mUnit.finalNTGLoad
								if mUnit.finalNTGLoad >= 0 and Pdisp <= 0:
									if delta <= reducedLoad:
										UpdateWorkingMPID(delta, MU_MPID, "Increase Load")
										mUnit.finalNTGLoad = mUnit.finalNTGLoad + delta
										MarginalUnitReserve = MarginalUnitReserve + delta
										delta = 0
										break
									else:
										UpdateWorkingMPID(reducedLoad, MU_MPID, "Increase Load")
										mUnit.finalNTGLoad = mUnit.finalNTGLoad + reducedLoad
										MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
										MarginalUnitReserve = 0
										delta = delta - reducedLoad
										MarginalUnit = UpdateSystem(delta, MarginalUnit, "Reduce", LFMPID)
										break
										# continue
								elif mUnit.finalNTGLoad == 0 and Pdisp > 0:
									if delta <= Pdisp:
										UpdateWorkingMPID(delta, MU_MPID, "Reduce")
										MarginalUnitReserve = MarginalUnitReserve + delta
										delta = 0
										break
									else:  ##delta > Pdisp:
										UpdateWorkingMPID(Pdisp, MU_MPID, "Reduce")
										MarginalUnitReserve = MarginalUnitReserve + Pdisp
										delta = delta - Pdisp
										if delta >= reducedLoad:
											UpdateWorkingMPID(reducedLoad, MU_MPID, "Increase Load")
											mUnit.finalNTGLoad = mUnit.finalNTGLoad + reducedLoad
											MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
											delta = delta - reducedLoad
											MarginalUnit = UpdateSystem(delta, MarginalUnit, "Reduce", LFMPID)
											break
											# continue
										else: ## delta < reducedLoad:
											UpdateWorkingMPID(delta, MU_MPID, "Increase Load")
											mUnit.finalNTGLoad = mUnit.finalNTGLoad + delta
											MarginalUnitReserve = MarginalUnitReserve + delta
											delta = 0
											break
							else:
								print "Pdisp :", Pdisp
								# raw_input()
								if delta > Pdisp:
									UpdateWorkingMPID(Pdisp, MU_MPID, "Reduce")
									delta = delta - Pdisp
									MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", LFMPID)
									MarginalUnitReserve = 0
									MarginalUnit = UpdateSystem(delta, MarginalUnit, "Reduce", LFMPID)
									break
									# continue
								else: ## delta <= Pdisp:
									UpdateWorkingMPID(delta, MU_MPID, "Reduce")
									MarginalUnitReserve = MarginalUnitReserve + delta
									delta = 0
									# raw_input("=====")
									print "delta :", delta
									break
			print "============================Return From Update System-----------"
			print MarginalUnit.serial, MarginalUnit.assetName
			# raw_input()
			
			return MarginalUnit
			
			
		def checkMarginalUnit(MarginalUnit, MOList, MPIDs):
			print MarginalUnit.assetName, "----", int(MarginalUnit.serial)
			for eachMPID in MPIDs:
				if eachMPID.mpidName == MarginalUnit.assetName:
					MPID = eachMPID
					break
			Pdisp, totalPmax = determineMPID_Gen(MPID)
			Pavailable = MarginalUnit.totalDisp_eachMPID    ###determineMU_Info(MarginalUnit)  ### Define
			Palready = MarginalUnit.totalDisp_eachMPID - MarginalUnit.availablePower
			print Pdisp, totalPmax, Pavailable   
			if Pdisp > Palready and Pdisp < Pavailable:
				delta = 0
				return delta, MarginalUnit
			elif Pdisp < Palready:
				control = "Increase"
				print "-----", control
				delta = abs(Palready - Pdisp)
				UpdateWorkingMPID(0, MPID, control)
				MarginalUnit, xx = self.UpdateMarginalUnit(MarginalUnit, "PREV", LFMPID)
				return delta, MarginalUnit
			elif Pdisp > Pavailable:
				control = "Reduce"
				print "-----", control
				delta = abs(Pavailable - Pdisp)
				UpdateWorkingMPID(delta, MPID, control)
				MarginalUnit, xx = self.UpdateMarginalUnit(MarginalUnit, "NEXT", LFMPID)
				return delta, MarginalUnit
		
		def checkMarginalUnit_Mismatch(MarginalUnit):
			print MarginalUnit.assetName, "----", int(MarginalUnit.serial)
			for eachMPID in self.MPIDs:
				if eachMPID.mpidName == MarginalUnit.assetName:
					MPID = eachMPID
					break
			Pdisp, totalPmax = determineMPID_Gen(MPID)
			Ptotal_uptoCurrentBlock = MarginalUnit.totalDisp_eachMPID    ###determineMU_Info(MarginalUnit)  ### Define
			Ptotal_previousBlock = MarginalUnit.totalDisp_eachMPID - MarginalUnit.availablePower
			
			print Pdisp, Ptotal_uptoCurrentBlock, Ptotal_previousBlock
			mismatch = 0 
			if Pdisp > Ptotal_uptoCurrentBlock:
				mismatch = Pdisp - Ptotal_uptoCurrentBlock
			elif Pdisp <= Ptotal_uptoCurrentBlock and Pdisp >= Ptotal_previousBlock:
				mismatch = 0
			elif Pdisp < Ptotal_previousBlock:
				mismatch = Pdisp - Ptotal_previousBlock

			return mismatch
			

		def assignSwingBus_v0(MarginalUnit):
			if MarginalUnit.assetName == 'BCHIMP':
				desiredSwingBus = 1520
			elif MarginalUnit.assetName == 'SPCIMP':
				desiredSwingBus = 1473
			else:
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					print gen.bus, gen.id
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id) ##(gen.bus, gen.id)
					if status != 0 :
						desiredSwingBus = gen.bus
						break
			# raw_input()
			############ Change the previous swing bus back tot Type - 2
			err, [buses, types] = psspy.abusint(-1, 1, ("NUMBER", "TYPE"))
			for bus, type in zip(buses, types):
				if type == 3:
					print "Prev. Swing Bus - ", bus
					psspy.bus_chng_3(bus, (2, ))
					if bus == 1473:
						# psspy.machine_chng_2(1473,r"""3""",[0,_i,_i,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
						psspy.purgmac(1473,r"""3""")
					break
				
					
			####  Assign new swing Bus -- Type Code 3
			print "New Swing Bus : ", desiredSwingBus 
			psspy.bus_chng_3(desiredSwingBus,[3,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
			Solve()
			return desiredSwingBus
			
		def assignSwingBus_v1(MarginalUnit):
			if MarginalUnit.assetName == 'BCHIMP':
				desiredSwingBus = 1520
			elif MarginalUnit.assetName == 'SPCIMP':
				##### keep BC as swing bus
				# desiredSwingBus = 1473
				desiredSwingBus = 1520
			else:
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					print gen.bus, gen.id
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id) ##(gen.bus, gen.id)
					if status != 0 :
						desiredSwingBus = gen.bus
						break
			# raw_input()
			############ Change the previous swing bus back tot Type - 2
			err, [buses, types] = psspy.abusint(-1, 1, ("NUMBER", "TYPE"))
			for bus, type in zip(buses, types):
				if type == 3:
					print "Prev. Swing Bus - ", bus
					psspy.bus_chng_3(bus, (2, ))
					# if bus == 1473:
						# # psspy.machine_chng_2(1473,r"""3""",[0,_i,_i,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
						# psspy.purgmac(1473,r"""1""")
					break
				
					
			####  Assign new swing Bus -- Type Code 3
			print "New Swing Bus : ", desiredSwingBus 
			psspy.bus_chng_3(desiredSwingBus,[3,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
			Solve()
			return desiredSwingBus
			
		def assignSwingBus(MarginalUnit):
			if MarginalUnit.relatedImportAsset == bc_imp or MarginalUnit.relatedImportAsset == sk_imp:
				desiredSwingBus = 1520
			# elif MarginalUnit.assetName == 'SPCIMP':
				# ##### keep BC as swing bus
				# # desiredSwingBus = 1473
				# desiredSwingBus = 1520
			else:
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					print gen.bus, gen.id
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id) ##(gen.bus, gen.id)
					if status != 0 :
						desiredSwingBus = gen.bus
						break
			# raw_input()
			############ Change the previous swing bus back tot Type - 2
			err, [buses, types] = psspy.abusint(-1, 1, ("NUMBER", "TYPE"))
			for bus, type in zip(buses, types):
				if type == 3:
					print "Prev. Swing Bus - ", bus
					psspy.bus_chng_3(bus, (2, ))
					# if bus == 1473:
						# # psspy.machine_chng_2(1473,r"""3""",[0,_i,_i,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
						# psspy.purgmac(1473,r"""1""")
					break
				
					
			####  Assign new swing Bus -- Type Code 3
			print "New Swing Bus : ", desiredSwingBus 
			psspy.bus_chng_3(desiredSwingBus,[3,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
			Solve()
			return desiredSwingBus
			
		
		def findMarginalUnitReserve(MarginalUnit):
			########## Determine MU reserve .....
			############# Updated by SDR - 20Mar2019
			print "Determine MU Reserve ... "
			MPID = findMarginalUnit_MPID_info(MarginalUnit)
			totalPgen, totalPmax = determineMPID_Gen(MPID) 
			print "Current Pgen : ", totalPgen
			
			if MarginalUnit.relatedImportAsset == bc_imp or MarginalUnit.relatedImportAsset == sk_imp or MarginalUnit.relatedImportAsset == mt_imp:
				MarginalUnitReserve = MarginalUnit.P_netImportExport - totalPgen
			else:
				if MarginalUnit.reduceLoadTag.upper() == 'YES' and MarginalUnit.finalNTGLoad > 0:
					MarginalUnitReserve = MarginalUnit.finalNTGLoad + MarginalUnit.totalDisp_eachMPID - totalPgen
				else:
					if MPID.emmoOffer == "Net-to-grid" and MPID.loadOffer == "Gross":
						MarginalUnitReserve = MarginalUnit.totalDisp_eachMPID - (totalPgen - self.btfGen_ss_net_gross[MPID.mpidName])
					else:
						MarginalUnitReserve = MarginalUnit.totalDisp_eachMPID - totalPgen
			print "MarginalUnitReserve : ", MarginalUnitReserve
			return MarginalUnitReserve
		
		
			
		def determineMismatch(MarginalUnit):
			########## Determine BC Tie Mismatch.....
			############# Updated by SDR - 20Mar2019
			print "Determine BC Tie Mismatch........... "
			psspy.progress("Determine BC Tie Mismatch........... ")
			
			current_bctie = TieMeasure()
			previous_target_bctie = MarginalUnit.P_prev_netImportExport_dict[bc]
			target_bctie = MarginalUnit.P_netImportExport_dict[bc]
			# if MarginalUnit.assetName != "BCHIMP":
			print MarginalUnit.assetName
			print target_bctie, current_bctie, previous_target_bctie
			
			if MarginalUnit.assetName != bc_imp and MarginalUnit.assetName != bc_exp:
				mismatch = (current_bctie - target_bctie)
			else:
				if current_bctie <= previous_target_bctie:
					mismatch = current_bctie - previous_target_bctie
				elif current_bctie > previous_target_bctie and current_bctie <= target_bctie:
					mismatch = 0
				elif current_bctie > target_bctie:
					mismatch = current_bctie - target_bctie 
			print "Mismatch : ", mismatch
			# raw_input()
			return mismatch
				 
		def FindMarginalUnit(self, LFMPID):  ###### Updated by SDR
			############## NOT REQUIRED in S-1 #######
			########## Dispatch Generations and Balancing - Initial .....
			############# Updated by SDR - 20Mar2019
			MOList = self.currentHourEMMO
			TotalDispatch = 0.0 # Initialize
			Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
			print Gen.real, (Load.real+Loss.real+ShuntLoss.real)
			TotalDemand = (Load.real+Loss.real+ShuntLoss.real)
			print "Real Total Demand ", TotalDemand
			
			for eachMORecord in MOList:
				TotalDispatch += eachMORecord.availablePower
				
				if TotalDispatch > TotalDemand:
					MarginalUnit = eachMORecord
					MarginalUnitReserve = TotalDispatch-TotalDemand #GSOUnit.maxDispatchamount 
					break
					## What if MaxDispatch < Pgen(MPIDUnit)
					# UnitReserve = Pmax - Pgen
			# print "TotalDispatch:", TotalDispatch, "\nTotalDemand:", TotalDemand, "\nGSOUnit", GSOUnit.gsoNumber
			# sys.exit()
			if MarginalUnit.assetName == LFMPID or MarginalUnit.assetName == 'BCHIMP' or MarginalUnit.assetName == 'SPCIMP':
				MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "NEXT", LFMPID)
			
			return MarginalUnit, MarginalUnitReserve
		
		def determineAvailableMW(currentHourEMMO, mpidName):
			############# Updated by SDR - 24May2019
			totalAvailableMW = 0
			foundTag = 0
			if len(currentHourEMMO) != 0:
				for eachrow in currentHourEMMO:
					if eachrow.assetName == mpidName:
						foundTag = 1
						totalAvailableMW = totalAvailableMW + eachrow.availablePower
			return totalAvailableMW, foundTag
		
		
		def dispatch_BTFGen_for_netEMMO_GrossLoad():
			############# Updated by SDR - 24May2019
			############################
			mpidlist_ss_net_gross = []
			btfGen_ss_net_gross = dict()
			for MPID in self.MPIDs:
				if MPID.locationType == "Self-supply":
					if MPID.emmoOffer == "Net-to-grid" and MPID.loadOffer == "Gross":
						mpidlist_ss_net_gross.append(MPID)
			
			total_btfGen_dispatched = 0
			for eachMPID in mpidlist_ss_net_gross:
				totalAvailableMW, foundTag = determineAvailableMW(self.currentHourEMMO, eachMPID.mpidName)
				if totalAvailableMW > 0 and foundTag == 1:
					loadmpids = eachMPID.loadmpids
					onsiteLoads = eachMPID.onsiteLoads
					genMPID = eachMPID.mpidName
					# dataToUseTag = 'Load Data'
					btfLoad_mwData = 0
					if len(loadmpids) > 0:
						for loadmpid in loadmpids:
							loads = onsiteLoads[loadmpid]
							btfLoad_mwData += getLoadMWData(loadmpid, self.loadData) * eachMPID.loadDistributionFactor	
					btfGen_mwData = btfLoad_mwData
					control = "Increase"
					UpdateWorkingMPID(btfGen_mwData, eachMPID, control, fulldispatchamount=None)
					btfGen_ss_net_gross[eachMPID.mpidName] = btfGen_mwData
					
					total_btfGen_dispatched = total_btfGen_dispatched + btfGen_mwData
			return total_btfGen_dispatched, btfGen_ss_net_gross
		
		
		def casePrep(condition, MarginalUnit=None):
			########## Dispatch Generations and Balancing - Initial .....
			############# Updated by SDR - 20Mar2019
			def casePrep_init():
				########## Dispatch Generations - Initial .....
				############# Updated by SDR - 20Mar2019
				self.P_export[bc] = -self.currentHourExports[bc_exp]
				self.P_import[bc] = 0 
				self.P_netImportExport[bc] = self.P_export[bc] + self.P_import[bc]
				
				self.P_export[sk] = -self.currentHourExports[sk_exp]
				self.P_import[sk] = 0 
				self.P_netImportExport[sk] = self.P_export[sk] + self.P_import[sk]
				
				self.P_export[mt] = -self.currentHourExports[mt_exp]
				self.P_import[mt] = 0 
				self.P_netImportExport[mt] = self.P_export[mt] + self.P_import[mt]
				
				self.initial_ExportMW = abs(self.P_export[bc] + self.P_export[sk] + self.P_export[mt])
				
				print "initial_ExportMW : ", self.initial_ExportMW
				
				## Dispatch Sask and MT tie flows (Initial Exports)
				setSk_Tie(self.P_netImportExport[sk])
				setMT_Tie(self.P_netImportExport[mt])
				
				
				Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
				TotalDemand = Load + Loss + ShuntLoss + self.initial_ExportMW
				TotalDispatch = 0
				self.initial_btfGen_dispatched, self.btfGen_ss_net_gross = dispatch_BTFGen_for_netEMMO_GrossLoad()
				TotalDispatch = self.initial_btfGen_dispatched
				
				bctie = 0 ### initial bctie
				previous_target_bctie = 0
				
				### Dispatch Generation - Follow EMMO ... 
				psspy.progress("\n\n======     DISPATCHING GENERATORS ===============\n")
				# while TotalDispatch < TotalDemand:
				# enable_print()
				
				
				for mUnit in self.currentHourEMMO:
					# enable_print()
					# print mUnit.assetName
					# raw_input()
					if TotalDispatch < TotalDemand:
						MPID = findMarginalUnit_MPID_info(mUnit)
						# print MPID
						# raw_input()
						if MPID != []:
							if MPID.lfTag != "SKIP":
								# TotalDispatch += mUnit.availablePower
								print "Total Dispatch : ",  TotalDispatch 
								print "Total Demand : ", TotalDemand 
								print "============================================================================"
								print "		Serial 			 MPID			P(Avaialble)"
								print int(mUnit.serial), " ----- ", mUnit.assetName,  mUnit.availablePower
								
								if mUnit.assetName == bc_imp:
									self.target_bctie = mUnit.P_netImportExport
									self.previous_target_bctie = self.P_netImportExport[bc]
									
									self.P_import[bc] = mUnit.P_import
									self.P_export[bc] = mUnit.P_export
									self.P_netImportExport[bc] = mUnit.P_netImportExport
									
									MarginalUnit = mUnit
									TotalDispatch += mUnit.availablePower
									
									continue
								
								elif mUnit.assetName == bc_exp:
									self.target_bctie = mUnit.P_netImportExport
									self.previous_target_bctie = self.P_netImportExport[bc]
									
									self.P_import[bc] = mUnit.P_import
									self.P_export[bc] = mUnit.P_export
									self.P_netImportExport[bc] = mUnit.P_netImportExport
									
									MarginalUnit = mUnit
									TotalDemand -= mUnit.availablePower
									
									continue
									
								elif mUnit.assetName == sk_imp:
									self.P_import[sk] = mUnit.P_import
									self.P_export[sk] = mUnit.P_export
									self.P_netImportExport[sk] = mUnit.P_netImportExport
									setSk_Tie(self.P_netImportExport[sk])
									
									MarginalUnit = mUnit
									TotalDispatch += mUnit.availablePower
									continue
									
								elif mUnit.assetName == sk_exp:
									self.P_import[sk] = mUnit.P_import
									self.P_export[sk] = mUnit.P_export
									self.P_netImportExport[sk] = mUnit.P_netImportExport
									setSk_Tie(self.P_netImportExport[sk])
									
									MarginalUnit = mUnit
									TotalDemand -= mUnit.availablePower
									continue
									
								elif mUnit.assetName == mt_imp:
									self.P_import[mt] = mUnit.P_import
									self.P_export[mt] = mUnit.P_export
									self.P_netImportExport[mt] = mUnit.P_netImportExport
									setMT_Tie(self.P_netImportExport[mt])
									
									MarginalUnit = mUnit
									TotalDispatch += mUnit.availablePower
									continue
									
								elif mUnit.assetName == mt_exp:
									self.P_import[mt] = mUnit.P_import
									self.P_export[mt] = mUnit.P_export
									self.P_netImportExport[mt] = mUnit.P_netImportExport
									setMT_Tie(self.P_netImportExport[mt])
									
									MarginalUnit = mUnit
									TotalDemand -= mUnit.availablePower
									continue
								
								else:
									if mUnit.reduceLoadTag.upper() == 'YES' and mUnit.deductibleNTGLoad > 0:
										# if MPID != []:
										totalPload, totalQload = determineMPID_Load(MPID)
										delta = mUnit.deductibleNTGLoad
										print "Delta :	", delta
										MarginalUnit = mUnit
										# raw_input()
										# if delta > 0:
										UpdateWorkingMPID(abs(delta), MPID, "Reduce Load", fulldispatchamount=None)
										TotalDemand -= mUnit.deductibleNTGLoad
										mUnit.finalNTGLoad = mUnit.finalNTGLoad - delta
										print "----------------------------------------"
										print "After Load Reduction Increase Gen .... "
										totalPgen, totalPmax = determineMPID_Gen(MPID)
										delta = totalPgen -  mUnit.totalDisp_eachMPID
										print "Delta :	", delta
										MarginalUnit = mUnit
										if delta > 0:
											UpdateWorkingMPID(abs(delta), MPID, "Reduce", fulldispatchamount=None)
										elif delta < 0 :
											UpdateWorkingMPID(abs(delta), MPID, "Increase", fulldispatchamount=None)
										else:
											continue
										TotalDispatch += mUnit.availablePower
										
									else:
										# if MPID != []:
										totalPgen, totalPmax = determineMPID_Gen(MPID)
										# delta = totalPgen -  mUnit.totalDisp_eachMPID
										delta = -mUnit.availablePower
										print "Delta :	", delta
										MarginalUnit = mUnit
										# raw_input()
										if delta > 0:
											UpdateWorkingMPID(abs(delta), MPID, "Reduce", fulldispatchamount=None)
										elif delta < 0 :
											UpdateWorkingMPID(abs(delta), MPID, "Increase", fulldispatchamount=None)
										else:
											continue
										TotalDispatch += mUnit.availablePower
								
								MarginalUnit = mUnit
								self.P_import[bc] = mUnit.P_import_dict[bc]
								self.P_export[bc] = mUnit.P_export_dict[bc]
								self.P_netImportExport[bc] = mUnit.P_netImportExport_dict[bc]
								
								self.P_import[mt] = mUnit.P_import_dict[mt]
								self.P_export[mt] = mUnit.P_export_dict[mt]
								self.P_netImportExport[mt] = mUnit.P_netImportExport_dict[mt]
								
								self.P_import[sk] = mUnit.P_import_dict[sk]
								self.P_export[sk] = mUnit.P_export_dict[sk]
								self.P_netImportExport[sk] = mUnit.P_netImportExport_dict[sk]
							else:
								enable_print()
								print "===================== ERROR ================================"
								print "MPID :", MPID.mpidName, " is tagged as SKIP in Gen-Mapping"
								print "==========================================================="
								raise 
						else:
							enable_print()
							print "======================== ERROR =================================="
							print "MPID :", mUnit.assetName, " is not included in the Gen Mapping"
							print "================================================================"
							raise 
						tempname = self.outputCaseName.split(".sav")[0]
						# psspy.save(tempname + "_GenDispatching_4.sav")
						print "Case Saved - MU: ", mUnit.assetName
						# raw_input("===next Unit ===")
					else:
						break
				
				# enable_print()
				print "================================================"
				print "TotalDemand, TotalDispatch : ", TotalDemand, TotalDispatch
				tempname = self.outputCaseName.split(".sav")[0]
				# psspy.save(tempname + "_GenDispatched_BeforeSolve_5.sav")
				# sys.exit()
				
				psspy.progress("TotalDemand, TotalDispatch : %s, %s " %(TotalDemand, TotalDispatch))
				
				writeEMMOLog("Before Balancing")
				# raw_input()
				# print temp_sum
				if TotalDemand > TotalDispatch:
					Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
					raise InsufficientSourceError(Load, Gen, Loss+ShuntLoss, "casePrep_init")
					
				caseprep_Solve()
				# psspy.save(tempname + "_GenDispatched_UnbalancedSolve_6.sav")
				
				print "------ STATS-1----------------"
				Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
				print "Gen = ", Gen
				print "Load + Loss : ", Load+Loss+ShuntLoss
				print "Import : ", self.P_import
				print "Export : ", self.P_export
				print "netExportImport : ", self.P_netImportExport
				current_bctie = TieMeasure()
				print "Current Tie : ", current_bctie
				print "MarginalUnit.serial	MarginalUnit.assetName	MarginalUnitReserve"
				print "MarginalUnit : ", MarginalUnit.serial, MarginalUnit.assetName
				
				
				
				# writeEMMOLog("Before Balancing")
				
				
				
				return MarginalUnit
			
			if condition == True:
				MarginalUnit = casePrep_init()
			
			MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
			print "MarginalUnit : ", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber, MarginalUnit.assetShortName, MarginalUnitReserve
			mismatch = determineMismatch(MarginalUnit)
			psspy.progress("\n\n======     TIE FLOW MATCHING ===============\n")
			print "Mismatch : ", mismatch
			# raw_input()
			
			iterationNumber = 1
			print "Next iterationNumber : ", iterationNumber
			while abs(mismatch) > flowTolerance and iterationNumber < iterationLimit:   #### Reduced Gen in Working MPID - Dispatch Up Total Gen from Merit Order
				print "======================================="
				print "Mismatch : ", mismatch
				print "--------------------------"
				
				if MarginalUnit.relatedImportAsset == bc_imp or MarginalUnit.relatedImportAsset == sk_imp or MarginalUnit.relatedImportAsset == mt_imp:
					if MarginalUnitReserve == 0 and mismatch >0 :
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", "")
					# elif MarginalUnitReserve == MarginalUnit.P_netImportExport - MarginalUnit.availablePower and mismatch<0:
					elif MarginalUnitReserve == MarginalUnit.availablePower and mismatch<0:
						MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", "")
				else:
					if MarginalUnit.reduceLoadTag.upper() == 'YES' and MarginalUnit.finalNTGLoad > 0:
						if MarginalUnitReserve == 0 and mismatch >0 :
							MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", "")
						elif MarginalUnitReserve == (MarginalUnit.deductibleNTGLoad + MarginalUnit.availablePower) and mismatch < 0:
							MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", "")
					else:
						if MarginalUnitReserve == 0 and mismatch >0 :
							MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", "")
						elif MarginalUnitReserve == MarginalUnit.totalDisp_eachMPID and mismatch < 0:
							MarginalUnit = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", "")
				
				if mismatch > 0:
					control = "Increase"
				elif mismatch < 0:
					control = "Reduce"
				
				
				MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
				print "MarginalUnit.serial	MarginalUnit.assetName	MarginalUnit.blockNumber	MarginalUnit.assetShortName	MarginalUnitReserve"				
				print MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber, MarginalUnit.assetShortName, MarginalUnitReserve
				
				# raw_input()
				# MarginalUnit, MarginalUnitReserve = UpdateSystem(mismatch, MarginalUnit, MarginalUnitReserve, self.currentHourEMMO, control, "")
				MarginalUnit = UpdateSystem(mismatch, MarginalUnit, control, "")
				
				caseprep_Solve()
				tempname = self.outputCaseName.split(".sav")[0]
				# psspy.save(tempname + "_temp.sav")
				# raw_input()
				
				MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
				print "MarginalUnit.serial	MarginalUnit.assetName	MarginalUnit.blockNumber	MarginalUnit.assetShortName	MarginalUnitReserve"				
				print MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber, MarginalUnit.assetShortName, MarginalUnitReserve
				
				mismatch = determineMismatch(MarginalUnit)
				print "\n Mismatch : ", mismatch
				psspy.progress("\n BC Tie Mismatch : %s" %mismatch)
				iterationNumber += 1
				print "Next iterationNumber : ", iterationNumber
				print "................"
				# raw_input()
			
			if abs(mismatch) > flowTolerance and iterationNumber >= iterationLimit:
				# Load, Gen, Loss, ShuntLoss = self.GetSystemTotals(True)
				Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
				raise iterationLimitError(mismatch, iterationNumber, Load, Gen, Loss+ShuntLoss)
			else:
				print mismatch
				MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
				self.MarginalUnitReserve = MarginalUnitReserve
				print "------ STATS----------------"
				Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
				print "Gen = ", Gen
				print "Load + Loss : ", Load+Loss+ShuntLoss
				print "Import : ", self.P_import
				print "Export : ", self.P_export
				print "netExportImport : ", self.P_netImportExport
				print "MarginalUnit.serial	MarginalUnit.assetName	MarginalUnitReserve"
				print "MarginalUnit : ", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnitReserve
				
				if condition:
					tempname = self.outputCaseName.split(".sav")[0]
					psspy.save(tempname + "_GenBalanced_7A.sav")
					# writeEMMOLog("After Balancing")
				else:
					tempname = self.outputCaseName.split(".sav")[0]
					psspy.save(tempname + "_GenBalanced_AfterHVDC_7A.sav")
					# writeEMMOLog("Gen Balanced after HVDC")
				# sys.exit()
				
				return MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit
		
		
				
		# def initializeLoad():
			# print 
			
		def isdLoadMapping(loadMapping):
			########## NOT REQUIRED .....
			############# Updated by SDR - 20Mar2019
			isdLoadList = []
			for eachload in loadMapping:
				# if eachload.isdtag == "ISD" or eachload.isdtag == "ISD-New": 
				# self.siteType = siteType
				if eachload.siteType == "Self-Supply": 
					bus_id = str(eachload.bus) + "-" + str(eachload.id)
					isdLoadList.append(bus_id)
			
			# enable_print()
			for row in isdLoadList:
				print row
			return isdLoadList
			
		def TurnOffLoads():
			########## Turning off all Loads (Initializing) .....
			############# Updated by SDR - 20Mar2019
			print ("Initializing Loads (switching off with Pload = 0) in basecase .... ")
			# psspy.progress("\n\n======     TURNING OFF NON-ISD LOADS ===============\n")
			psspy.progress("\n\n======     TURNING OFF ALL LOADS ===============\n")
			
			buses, ids, statuses, loads = FindAllLoadData()
			# print buses, ids, statuses, loads
			# raw_input()
			for bus, id, status, load in zip(buses, ids, statuses, loads):
				# bus_id = str(bus) + "-" + str(id)
				# print bus_id
				id = id.strip(' ')
				UpdateLoad(bus, id, 0, 0, 0)
		
		def AssignNonGenLoads(loadData, loadMvarData, loadMapping):
			########## Assign Non-gen Loads .....
			############# Updated by SDR - 20Mar2019
			print "Assigning Load Values to the Non Gen Load MPIDs ....."
			psspy.progress("\n\n=DISPATCHING NON-Gen LOADS ===============\n")
			loadmpids = [] 
			for eachloadMPID in loadMapping:
				loadmpids.append(eachloadMPID.loadMPID)
			
			loads_in_loadmpids = dict()
			for eachloadMPID in loadMapping:
				number_of_loads = loadmpids.count(eachloadMPID.loadMPID)
				loads_in_loadmpids[eachloadMPID.loadMPID] = number_of_loads
				# print eachloadMPID.loadMPID, loads_in_loadmpids[eachloadMPID.loadMPID]
			
			for eachloadMPID in loadMapping:
				# if eachloadMPID.isdtag == "ISD" or  eachloadMPID.isdtag == 'ISD-New': 
					# ###### SKIP ISD LOads
					# continue
				# else:
				workingloadmpid = eachloadMPID.loadMPID
				loadbus = eachloadMPID.bus
				loadid = eachloadMPID.id
				number_of_loads = loads_in_loadmpids[workingloadmpid]
				mwData = 0
				mvarData = 0
				mvarTag = ''
				for eachloadmpidData in loadData:
					#mpidName, mwData
					if eachloadmpidData.mpidName == workingloadmpid:
						mwData = eachloadmpidData.mwData
						break
				for eachloadmpidData in loadMvarData:
					#mpidName, mwData
					if eachloadmpidData.mpidName == workingloadmpid:
						mvarTag = eachloadmpidData.mvarDataTag
						pfData = eachloadmpidData.mvarData
						break
				# pf = 0.9
				# pload = mwData/number_of_loads
				# qload = pload * math.tan(math.acos(pf))
				if mvarTag == 'OK':
					pload = mwData/number_of_loads
					# if pfData != "" and pfData != 0.0:
						# qload = pload * math.tan(math.acos(pfData))
					if pfData != "" and abs(pfData) >= 0.75:
						qload = pload * math.tan(math.acos(pfData))
					else:
						pf = 0.9
						qload = pload * math.tan(math.acos(pf))
				# elif (mvarTag == 'Review' or mvarTag == 'No Data'):
					# pf = 0.9
					# pload = mwData/number_of_loads
					# qload = pload * math.tan(math.acos(pf))
				else:
					pf = 0.9
					pload = mwData/number_of_loads
					qload = pload * math.tan(math.acos(pf))
				
				# print workingloadmpid, pload, qload, loadbus, loadid
				
				psspy.progress("\n ================= Updating LOAD MPID : %s  , BUS = %s,  ID = '%s \n" %(workingloadmpid, loadbus, loadid))
				psspy.progress("PLOAD = %s,  QLOAD = %s \n" %(pload, qload))
				if pload != 0:
					powerFactor = math.cos(math.atan(qload/pload))
				else:
					powerFactor = "N/A"
				psspy.progress("\n Applied PF = %s \n" %powerFactor)
				psspy.progress("\n Number_of_loads = %s , MW DATA = %s, MVAR TAG : %s, MVAR DATA = %s \n" %(number_of_loads, mwData, mvarTag, pfData))
				
				if pload != 0:
					status = 1
				else:
					status = 0
				# print eachloadMPID.loadMPID, mwData
				# print (loadbus, loadid, status, pload, qload)
				UpdateLoad(loadbus, loadid, status, pload, qload)
				# raw_input()

		
					
		def AssignOnsiteLoads(loadData, grossloaddata, tssData, loadMapping, MPIDs):
			########## Assign Onsite Loads .....
			############# Updated by SDR - 20Mar2019
			print ("Assigning Onsite Loads in basecase .... ")
			psspy.progress("\n\n======     Assigning Onsite Loads in basecase ===============\n")
			# loadMPID, bus, id
			loadmpids = [] 
			for eachMPID in MPIDs:
				loadmpids = eachMPID.loadmpids
				onsiteLoads = eachMPID.onsiteLoads
				genMPID = eachMPID.mpidName
				# print "======================================================================================"
				# print eachMPID.mpidName
				# print loadmpids
				# print onsiteLoads
				# print eachMPID.locationType
				dataToUse = []
				dataToUseTag = 'Load Data'
				if (eachMPID.locationType == 'Self-supply'):
					if eachMPID.emmoOffer == "Gross" and eachMPID.loadOffer == "Gross":
						dataToUse = loadData
						dataToUseTag = 'Load Data'
					elif eachMPID.emmoOffer == "Net-to-grid" and eachMPID.loadOffer == "Gross":
						dataToUse = loadData
						dataToUseTag = 'Load Data'
					elif eachMPID.emmoOffer == "Gross" and eachMPID.loadOffer == "Net-to-grid":
						dataToUse = grossloaddata
						dataToUseTag = 'Gross Load Data'
					elif eachMPID.emmoOffer == "Net-to-grid" and eachMPID.loadOffer == "Net-to-grid":
						dataToUse = loadData
						dataToUseTag = 'Load Data'
				elif (eachMPID.locationType == 'Reversing POD') or (eachMPID.locationType == 'Source Asset'):
						dataToUse = loadData
						dataToUseTag = 'Load Data'
				elif (eachMPID.locationType == 'DOS'):
						dataToUse = loadData
						dataToUseTag = 'Load Data'
				else:
					print "Import or Export Services"
					# continue
				if len(loadmpids) > 0:
					if dataToUseTag == 'Load Data':
						for loadmpid in loadmpids:
							loads = onsiteLoads[loadmpid]
							
							mwData = getLoadMWData(loadmpid, dataToUse) * eachMPID.loadDistributionFactor
							
							# print "==============================="
							# print loadmpid, mwData
							
							for load in loads:
								
								loadbus = int(load.split("-")[0])
								loadid = load.split("-")[1]
								
								pload = mwData/len(loads)
								pf = 0.9
								qload = pload * math.tan(math.acos(pf)) 
								
								if pload != 0:
									status = 1
								else:
									status = 0
								# print loadmpid, eachMPID.emmoOffer, eachMPID.loadOffer, eachMPID.locationType
								# print (loadbus, loadid, status, pload, qload)
								psspy.progress("\n %s, %s, %s, %s\n" %(loadmpid, eachMPID.emmoOffer, eachMPID.loadOffer, eachMPID.locationType))
								psspy.progress ("\n %s, %s, %s, %s, %s\n" %(loadbus, loadid, status, pload, qload))
								psspy.progress("\n Updating Load...\n")
								UpdateLoad(loadbus, loadid, status, pload, qload)
								
									
					elif dataToUseTag == 'Gross Load Data':
						for loadmpid in loadmpids:
							loads = onsiteLoads[loadmpid]
							mwData = getLoadMWData(genMPID, dataToUse)/len(loadmpids)
							# print "==============================="
							# print loadmpid, mwData
							
							for load in loads:
								
								loadbus = int(load.split("-")[0])
								loadid = load.split("-")[1]
								
								pload = mwData/len(loads)
								pf = 0.9
								qload = pload * math.tan(math.acos(pf)) 
								
								if pload != 0:
									status = 1
								else:
									status = 0
								# print loadmpid, eachMPID.emmoOffer, eachMPID.loadOffer, eachMPID.locationType
								# print (loadbus, loadid, status, pload, qload)
								psspy.progress("\n %s, %s, %s, %s\n" %(loadmpid, eachMPID.emmoOffer, eachMPID.loadOffer, eachMPID.locationType))
								psspy.progress ("\n %s, %s, %s, %s, %s\n" %(loadbus, loadid, status, pload, qload))
								psspy.progress("\n Updating Load...\n")
								UpdateLoad(loadbus, loadid, status, pload, qload)
								# raw_input()
					else:
						print "Import or Export Services"
				
		def initializeGens(currentHourEMMO, MPIDs):
			############ turnoff_all_gens()
			#### Updated by SDR 20Mar2019......
			print "Initializing Generators .... "
			psspy.progress("\n\n Initializing GENS  ==================================\n")
			print "Switching off all machines ... "
			buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases = FindAllMachineData(sid = -1, flag = 4)
			for bus, id, status, pgen, pmax, pmin, qmax, qmin, mbase in zip(buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases):
				if bus != 1520:
					pgen = 0
					status = 0
					# UpdateGen(bus, id, pgen, status)
					InitGen(bus, id, pgen,)
			# UpdateLoad(1473, '34', 1, 0, 0) ###Status=1
			
			print "Leaving Offered Generators On with Reactive Capability .... "
			currentHourOfferredGens = []
			if len(currentHourEMMO) != 0:
				for eachrow in currentHourEMMO:
					currentHourOfferredGens.append(eachrow.assetName)
				
			for MPID in MPIDs:
				if MPID.mpidName not in [bc_exp, bc_imp, sk_exp, mt_exp]:
					if MPID.emmoOffer == 'Net-to-grid':
						psspy.progress("\n Leaving Gen on with Reactive Capability, MPID : %s \n" %MPID.mpidName)
						for gen in MPID.generators:
							pgen = 0
							status = 1
							UpdateGen(gen.bus, gen.id, pgen, status)
					else:
						if MPID.mpidName in currentHourOfferredGens:
							psspy.progress("\n Leaving Gen on with Reactive Capability, MPID : %s \n" %MPID.mpidName)
							for gen in MPID.generators:
								pgen = 0
								status = 1
								UpdateGen(gen.bus, gen.id, pgen, status)
						# else:
							# UpdateGen(gen.bus, gen.id, 0, 0)
		
		def updateEMMO(eachMPID, mwData_tss, delta):
			################ Not required ######## 
			for munit in self.currentHourEMMO:
				if munit.assetName == eachMPID.mpidName and munit.blockNumber == 0:
					if munit.availablePower < mwData_tss:
						munit.availablePower = mwData_tss
						munit.totalDisp_eachMPID = mwData_tss
						# eachemmo = [munit.assetName, munit.blockNumber, munit.availablePower, munit.totalDisp_eachMPID]
						# self.emmoUpdateList.append(eachemmo)
						self.emmoUpdateList[munit.assetName] = [munit.serial, munit.blockNumber, munit.availablePower, munit.totalDisp_eachMPID]
		
		
		def extractImportExport(MarginalUnit):
			### Updated by SDR - 20 Mar 2019
			print "Extracting Import and Export Flows .... "
			IE_flows = dict()
			IE_flows[bc_imp] = 0
			IE_flows[bc_exp] = -self.currentHourExports[bc_exp]
			IE_flows[sk_imp] = 0
			IE_flows[sk_exp] = -self.currentHourExports[sk_exp]
			IE_flows[mt_imp] = 0
			IE_flows[mt_exp] = -self.currentHourExports[mt_exp]
			
			MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)

			for unit in self.currentHourEMMO:
				if unit.serial != MarginalUnit.serial:
					if unit.assetName == bc_imp:
						IE_flows[bc_imp] = unit.P_import
					elif unit.assetName == bc_exp:
						IE_flows[bc_exp] = unit.P_export
					elif unit.assetName == sk_imp:
						IE_flows[sk_imp] = unit.P_import
					elif unit.assetName == sk_exp:
						IE_flows[sk_exp] = unit.P_export
					elif unit.assetName == mt_imp:
						IE_flows[mt_imp] = unit.P_import
					elif unit.assetName == mt_exp:
						IE_flows[mt_exp] = unit.P_export
				else:
					if MarginalUnit.assetName == bc_imp:
						IE_flows[bc_exp] = MarginalUnit.P_export
						IE_flows[bc_imp] = MarginalUnit.P_import - MarginalUnitReserve
					elif MarginalUnit.assetName == bc_exp:
						IE_flows[bc_exp] = MarginalUnit.P_export - MarginalUnitReserve
						IE_flows[bc_imp] = MarginalUnit.P_import	
					
					elif MarginalUnit.assetName == sk_imp:
						IE_flows[sk_exp] = MarginalUnit.P_export
						IE_flows[sk_imp] = MarginalUnit.P_import - MarginalUnitReserve
					elif MarginalUnit.assetName == sk_exp:
						IE_flows[sk_exp] = MarginalUnit.P_export - MarginalUnitReserve
						IE_flows[sk_imp] = MarginalUnit.P_import	
					
					elif MarginalUnit.assetName == mt_imp:
						IE_flows[mt_exp] = MarginalUnit.P_export
						IE_flows[mt_imp] = MarginalUnit.P_import - MarginalUnitReserve
					elif MarginalUnit.assetName == mt_exp:
						IE_flows[mt_exp] = MarginalUnit.P_export - MarginalUnitReserve
						IE_flows[mt_imp] = MarginalUnit.P_import	
					break
			return IE_flows
				
		#########################################
		def writeEMMOLog(tag):
			fileName = "Log_EMMO_Adjusted - " + tag + ".txt"
			EMMO_Log_Modified = open(fileName, "w")
			EMMO_Log_Modified.write("time	serial	assetName	relatedImportAsset	assetShortName	Import_Export	blockNumber	flexibility	offerPrice	blockSize	availablePower	dispatchedPower	capabilityMW	totalDisp_eachMPID	P_export	P_import	P_netImportExport	emmoOffer	loadOffer	CriteriaCheckDecision	deductibleNTGLoad	reduceLoadTag	finalNTGLoad	P_export_dict[bc]	P_import_dict[bc]	P_netImportExport_dict[bc]	P_prev_netImportExport_dict[bc]	P_export_dict[sk]	P_import_dict[sk]	P_netImportExport_dict[sk]	P_prev_netImportExport_dict[sk]	P_export_dict[mt]	P_import_dict[mt]	P_netImportExport_dict[mt]	P_prev_netImportExport_dict[mt]")
			for mUnit in self.currentHourEMMO:
				# print mUnit.time, mUnit.serial, mUnit.assetName, mUnit.relatedImportAsset, mUnit.assetShortName, mUnit.Import_Export, mUnit.blockNumber, mUnit.flexibility, mUnit.offerPrice, mUnit.blockSize, mUnit.availablePower, mUnit.dispatchedPower, mUnit.capabilityMW, mUnit.totalDisp_eachMPID, mUnit.P_export, mUnit.P_import, mUnit.P_netImportExport
				
				EMMO_Log_Modified.write("\n")
				EMMO_Log_Modified.write("%s\t"*35 %(mUnit.time, mUnit.serial, mUnit.assetName, mUnit.relatedImportAsset, mUnit.assetShortName, mUnit.Import_Export, mUnit.blockNumber, mUnit.flexibility, mUnit.offerPrice, mUnit.blockSize, mUnit.availablePower, mUnit.dispatchedPower, mUnit.capabilityMW, mUnit.totalDisp_eachMPID, mUnit.P_export, mUnit.P_import, mUnit.P_netImportExport, mUnit.emmoOffer, mUnit.loadOffer, mUnit.CriteriaCheckDecision, mUnit.deductibleNTGLoad, mUnit.reduceLoadTag, mUnit.finalNTGLoad, 
				mUnit.P_export_dict[bc], mUnit.P_import_dict[bc], mUnit.P_netImportExport_dict[bc], mUnit.P_prev_netImportExport_dict[bc], 
				mUnit.P_export_dict[sk], mUnit.P_import_dict[sk], mUnit.P_netImportExport_dict[sk], mUnit.P_prev_netImportExport_dict[sk], 
				mUnit.P_export_dict[mt], mUnit.P_import_dict[mt], mUnit.P_netImportExport_dict[mt], mUnit.P_prev_netImportExport_dict[mt]))
				# EMMO_Log_Modified.write("\n")
							
			EMMO_Log_Modified.close()
			
		
		def basecaseprep():
			# raw_input("=======HOLD ON ===")
			print "==================================="
			print "Start Preparing Basecases .... "
			psspy.case(self.topologyCase)
			psspy.solution_parameters_4((psspy._i, 50), (psspy._f,) *5 + (0.01, ))
			
			tempname = self.outputCaseName.split(".sav")[0]
			psspy.progress("\n\n=========     INITIALIZING LOADS ===============\n")
			
			## Switching off all loads...
			TurnOffLoads()
			AssignNonGenLoads(self.loadData, self.loadMvarData, self.loadMapping)
			# psspy.save(tempname + "_NonGenLoadAssigned_1.sav")
			## Onsite Load Dispatch ...
			# AssignISDLoads(self.loadData, self.grossloaddata, self.tssData, self.loadMapping, self.MPIDs)
			AssignOnsiteLoads(self.loadData, self.grossloaddata, self.tssData, self.loadMapping, self.MPIDs)
			# psspy.save(tempname + "_OnsiteLoads_2.sav")
			## Generation Initialization ....
			initializeGens(self.currentHourEMMO, self.MPIDs)
			psspy.save(tempname + "_GeneratorsInitialzed_3.sav")
			## Generation Dispatch ....
			MUserial, MUassetName, MarginalUnit = casePrep(True, None)
			# psspy.save(tempname + "_GenerationDispatched_7.sav")
			caseprep_Solve()
			
			psspy.progress(" ===================  Month : %s ======= " %self.month)
			print "============================"
			# enable_print()
			print self.month
			print self.day
			print self.year
			# raw_input()
			if int(self.year) <= 2015:
				psspy.progress("============HVDC Lines don't Exist===========")
				savedOWSP = 0
				savedOESP = 0
				newWATL = 0 
				newEATL = 0
			else:
				try:
					import setHvdcDispatch
					# savedOWSP, savedOESP, newWATL, newEATL = setHvdcDispatch.hvdcMain(self.month, self.year)
					savedOWSP, savedOESP, newWATL, newEATL = setHvdcDispatch.hvdcMain(self.month, self.year)
					print "===================HVDC Dispatch Done"
					psspy.progress("\n\n ==================== HVDC Dispatch Done =============== \n")
					
				except:
					Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
					raise HvdcError(Load, Gen, Loss+ShuntLoss)
			
				
				# psspy.save(tempname + "_After_HVDC_8.sav")
				MUserial, MUassetName, MarginalUnit = casePrep(False, MarginalUnit)
				caseprep_Solve()
				# psspy.save(tempname + "_Final_9.sav")
			
			
			
			Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
			print Gen.real, Load.real, Loss.real+ShuntLoss.real, (Load.real+Loss.real+ShuntLoss.real)
			print("======     BASE CASE PREP - DONE ===============")
			psspy.progress("\n\nGen = %s, Load = %s, Loss = %s, Total Demand = %s" %(Gen.real, Load.real, Loss.real+ShuntLoss.real, (Load.real+Loss.real+ShuntLoss.real)))
			psspy.progress("\n\n======     BASE CASE PREP - DONE ===============")
			
			
			return MUserial, MUassetName, MarginalUnit, savedOWSP, savedOESP, newWATL, newEATL
		
		
		psselogFile = self.outputCaseName.split(".sav")[0] + "_PSSEprogress.txt"
		psspy.progress_output(2,psselogFile,[0,0])
		
		MUserial, MUassetName, MarginalUnit, savedOWSP, savedOESP, newWATL, newEATL = basecaseprep()
		print MUserial, MUassetName, MarginalUnit.blockNumber, savedOWSP, savedOESP, newWATL, newEATL
		self.IE_flows = extractImportExport(MarginalUnit)
		print self.IE_flows
		
		finalcheckSol()
		
		psspy.save(self.outputCaseName)
		Load, Gen, Loss, ShuntLoss = GetSystemTotals(True)
		print "\n Gen , Load, Loss+ShuntLoss, Load+Loss+ShuntLoss : ", Gen.real, Load.real, Loss.real+ShuntLoss.real, (Load.real+Loss.real+ShuntLoss.real)
		print("======     BASE CASE PREP with HVDC Dispatch - DONE ===============")
		psspy.progress("\n\nGen = %s, Load = %s, Loss = %s, Total Demand = %s" %(Gen.real, Load.real, Loss.real+ShuntLoss.real, (Load.real+Loss.real+ShuntLoss.real)))
		psspy.progress("\n\n======     BASE CASE PREP with HVDC Dispatch - DONE ===============\n")
		
		return  self.outputCaseName, self.emmoUpdateList, MarginalUnit, savedOWSP, savedOESP, newWATL, newEATL, Load, Gen, Loss+ShuntLoss, self.initial_btfGen_dispatched
		# raw_input()
		# sys.exit()
		
		#############################
		########################################
		#######################################################
		
def TieMeasure():
	print "Measure Ab-Bc Tie Flow (+Ve is Import, -Ve is Export) ... "
	Pm = 0
	# ab_bc
	for br in ab_bc:
		# print br
		err, temp_flow = psspy.brnflo(br[0], br[1], br[2])
		Pm += temp_flow.real
	
	# abbc_tieFlow = -Pm.real
	abbc_tieFlow = Pm.real
	print "AB-BC Tie Flow MW (+Ve is Import, -Ve is Export): ", abbc_tieFlow
	
	if abbc_tieFlow >= 0:
		print("Import")  
	else: 
		print("Export")
	
	return abbc_tieFlow
	

def GetSystemTotals(excludeWSCC):
	print "Determine System Total ..."
	# system99load = GetSystem99Load(excludeWSCC)
	ierr, totals2, motors2 = psspy.scal_2(0, 1, 0, (0, 0, 0, 0, 0), (0, 0, 0, 0, 0, 0, 0))
	motorLoad = -totals2[6]
	# totalLoad_99_plus_motor = system99load + motorLoad
	# print system99load, motorLoad
	if not excludeWSCC:
		err, load = psspy.systot("LOAD")
		err, gen = psspy.systot("GEN")
		err, loss = psspy.systot("LOSS") 
		err, alshnt = psspy.systot("ALSHNT") 
		
		status, sk_pload, sk_qload = getLoadData(skTie_bus, skTie_loadId)
		status, mt_pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(mtTie_genbus, mtTie_genId)
		
		# if pload < 0:
			# totalLoad = load.real - pload
		# else:
			# totalLoad = load.real - pload
		
		totalLoad = load.real - sk_pload
		totalGen = gen.real - mt_pgen
		# if mt_pgen>0:
			# totalGen = gen.real - mt_pgen
		# else:
			# totalGen = gen.real 
		# return load.real, gen.real, loss.real, alshnt.real
		return totalLoad, totalGen, loss.real, alshnt.real
	
	
	load_AIES, gen_AIES, loss_AIES, loss_alshnt = GetSystemTotals(False)
	# print load_AIES, gen_AIES, loss_AIES, loss_alshnt
	# load_AIES, gen_AIES, loss_AIES, loss_alshnt = excludeWSCCinfo()
	err, load_wscc = psspy.ardat(WSCCArea, 'LOAD')
	err, gen_wscc = psspy.ardat(WSCCArea, 'GEN')
	err, loss_wscc = psspy.ardat(WSCCArea, 'LOSS')
	err, loss_alshnt = psspy.systot("ALSHNT")
	
	# print load_wscc, gen_wscc, loss_wscc, loss_alshnt
	# raw_input()
	if load_wscc != None:
		load_AIES = load_AIES - load_wscc.real
	else:
		load_AIES = load_AIES
	
	gen_AIES = gen_AIES - gen_wscc.real
	loss_AIES = loss_AIES - loss_wscc.real
	loss_alshnt = loss_alshnt.real
	loss_total_AIES = loss_AIES
	print "load_AIES	gen_AIES	loss_total_AIES"
	print load_AIES, gen_AIES, loss_total_AIES+loss_alshnt
	# raw_input("---")
	
	return load_AIES, gen_AIES, loss_total_AIES, loss_alshnt
		

def setSk_Tie(netTieFlow):
	# netTieFlow = importMW - exportMW
	# skTie_bus = 1473
	# skTie_loadId = '34'
	print "Set SK Tie Flow with netFlow : ", netTieFlow, "MW .... "
	# if netTieFlow !=0:
		# status =  1
	# else:
		# status = 0
	status = 1
	err = psspy.load_chng_4(skTie_bus, skTie_loadId, (status,_i,_i,_i,_i,_i), (-netTieFlow, _f, _f,_f,_f,_f)  )
	
def setBC_Tie(netTieFlow):
	print "===="

def setMT_Tie(netTieFlow ):
	# netTieFlow = importMW - exportMW
	print "Set MT Tie Flow with netFlow : ", netTieFlow, "MW .... "
	status = 1
	UpdateGen(mtTie_genbus, mtTie_genId, netTieFlow, status)
	
	
	



			
def determine_mpidInternalLoss(MPIDs):
	
	totalMPIDLosses = 0
	for MPID in MPIDs:
		initmpidInternalLoss = 0
		mpidsubsystem = MPID.MPID_buses
		# mpidsubsystem.append(MPID.interfaceBus)
		# print mpidsubsystem
		if mpidsubsystem != []:
			sid = psspy.bsys(0,0,[ 0.4, 500.],0,[],len(mpidsubsystem),mpidsubsystem,0,[],0,[])
			ties = 1   ######## For each end of interior subsystem buses only
			flag = 2
			busesFrom, busesTo, statuses, ids, pflows, plosses = FindAllFlowData(sid, ties, flag)
			totalLoss = 0
			if busesFrom != [] and busesTo != [] and ids != []:
				for (frombus, tobus, id, status, pflow, ploss) in zip(busesFrom, busesTo, ids, statuses, pflows, plosses):
					# print frombus, tobus, id, status, pflow, ploss
					totalLoss += ploss
					initmpidInternalLoss = (totalLoss/2)
			else:
				initmpidInternalLoss = 0
		else:
			initmpidInternalLoss = 0
		totalMPIDLosses += initmpidInternalLoss
	return totalMPIDLosses

class MPID(object):  ## Updated by SDR 20-Mar-2019
    # def __init__(self, mpidName, facilityName, loadmpid, tag, ISDtag, generators, loads, interfaceBus, MPID_buses, netFlow ):
    def __init__(self, mpidName, facilityName, lfTag, loadmpids, emmoOffer, loadOffer, locationType, generators, onsiteLoads, loadDistributionFactor, interfaceBus, MPID_buses, netFlow ):
		self.mpidName = mpidName
		self.facilityName = facilityName
		self.lfTag = lfTag
		self.loadmpids = loadmpids
		self.emmoOffer = emmoOffer
		self.loadOffer = loadOffer 
		
		self.locationType = locationType
		
		self.generators = generators
		self.onsiteLoads = onsiteLoads
		self.loadDistributionFactor = loadDistributionFactor
		
		self.interfaceBus = interfaceBus
		self.MPID_buses = MPID_buses
		self.netFlow = netFlow


class loadObject(object):
	def __init__(self, bus, id):
		self.bus = bus
		self.id = id
		# self.pload = pload
		# self.qload = qload

class generatorObject(object):
	def __init__(self, bus, id):
		self.bus = bus
		self.id = id
		# self.pgen = pgen
		# self.pmax = pmax
		# self.pmin = pmin
		# self.qmax = qmax
		# self.qmin = qmin
		# self.mbase = mbase


def findSwingBus():
	err, [buses, types] = psspy.abusint(-1, 1, ("NUMBER", "TYPE"))
	for bus, type in zip(buses, types):
		if type == 3:
			return bus
			# print "Prev. Swing Bus - ", bus
			# psspy.bus_chng_3(bus, (2, ))
			break
def InitGen(bus, id, pgen):
	psspy.progress("Initializing Gen : %s-%s, %s MW" %(bus, id, pgen))
	status = 0
	err = psspy.machine_chng_2(bus, id, (status,_i,_i,_i,_i,_i), (pgen, ))
	
	
	
def UpdateGen(bus, id, pgen, status):
	# print "Gen Dispatch Updates: ", bus, id, pgen, status
	# if pgen == 0:
		# status = 0
	# else:
	
	status = 1
	err = psspy.machine_chng_2(bus, id, (status,_i,_i,_i,_i,_i), (pgen, ))
	swingBus = findSwingBus()
	# busType = _i
	
	if bus == swingBus:	
		busType = 3
		psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	else:
		busType = 2
		psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
		# else:
			# busType = _i
			# psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	print "Gen Dispatch Updates: ", bus, id, pgen, "status : ", status, "Bus Type :", busType
	# psspy.save("saved_case.sav")
	
def UpdateGen_Max(bus, id, pgen, pmax, status):
	# if pgen == 0:
		# status = 0
	# else:
		# status = 1
	
	status = 1
	err = psspy.machine_chng_2(bus, id, (status,_i,_i,_i,_i,_i), (pgen,_f,_f,_f,pmax, ))
	swingBus = findSwingBus()
	# busType = _i
	
	if bus == swingBus:	
		busType = 3
		psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	else:
		busType = 2
		psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	
		# if status == 1:
			# busType = 2
			# psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
		# else:
			# busType = _i
			# psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	print "Gen Dispatch Updates: ", bus, id, pgen, "status : ", status, "Bus Type :", busType
	# temp_sum += pgen
	# print temp_sum
			




	

############## Determining Gen Data
def FindAllMachineData(sid = -1, flag = 4):  ## ## Updated by SDR
	# sid = -1  ### by Default
	# flag = 4 ### for All machines
	err, [buses, statuses] = psspy.amachint(sid, flag, ("NUMBER", "STATUS"))
	err, [ids] = psspy.amachchar(sid, flag, ("ID",))
	err, [pgens, pmaxes, pmins, qmaxes, qmins, mbases] = psspy.amachreal(sid, flag, ("PGEN", "PMAX", "PMIN", "QMAX", "QMIN", "MBASE"))
	
	
	
	return buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases

def GetGenData(getbus, getid): ## Updated by SDR
	#### status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(getbus, getid)
	# print "---", getbus, getid
	buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases = FindAllMachineData(sid = -1, flag = 4)
	# print ids
	
	# raw_input()
	for (bus, id, status, pgen, pmax, pmin, qmax, qmin, mbase) in zip(buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases):
		# print bus, id 
		if bus == getbus and id.strip(" ") == getid:
			# if id == '3':
			# print "FOUND"
			
			return status, pgen, pmax, pmin, qmax, qmin, mbase
	# raw_input("-------")
	print "Generator Not Found"
	raise ValueError
			
	# return status, pgen, pmax, pmin, qmax, qmin, mbase

	




	
def determineMPID_Load(MPID):
	### Updated by sdr - 20-Mar-2019
	# print MPID.mpidName
	totalPload = 0
	totalQload = 0
	
	if MPID.mpidName not in Import_Export_Services:
		for loadmpid in MPID.loadmpids:
			loads = MPID.onsiteLoads[loadmpid]
			for load in loads:
				loadbus = int(load.split("-")[0]) 
				loadid = load.split('-')[1]
				status, pload, qload = getLoadData(loadbus, loadid)
				totalPload = totalPload + pload
				totalQload = totalQload + qload
	print totalPload, totalQload
	return totalPload, totalQload
############### Find Bus Data
	
def determineMPID_Gen(MPID):
	### Updated by sdr - 20-Mar-2019
	# print MPID.mpidName
	totalPgen = 0
	totalPmax = 0
	# if MPID.mpidName == 'BCHIMP':
	if MPID.mpidName == bc_imp or MPID.mpidName == bc_exp:
		totalPgen = TieMeasure()
		totalPmax = totalPgen
	# elif MPID.mpidName == 'SPCIMP':
	elif MPID.mpidName == sk_imp or MPID.mpidName == sk_exp:
		status, pload, qload = getLoadData(skTie_bus, skTie_loadId)
		totalPgen = - pload
		totalPmax = totalPgen
	else:
		if MPID.generators != '':
			for gen in MPID.generators:
				status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
				if status != 0:
					totalPgen += pgen
				totalPmax += pmax
	print totalPgen, totalPmax
	return totalPgen, totalPmax
############### Find Bus Data




############### Determining Load Data ###
def FindAllLoadData(sid = -1, flag = 4):
	err, [buses, statuses] = psspy.aloadint(sid, flag, ("NUMBER", "STATUS"))
	err, [ids] = psspy.aloadchar(sid, flag, ("ID", ))
	err, [loads] = psspy.aloadcplx(sid, flag, ("TOTALACT", ))
	return buses, ids, statuses, loads
	
def checkLoadExistence(loadbus, loadid):
	# # # # print "Load Element Checking in Topology Case..."
	##########################################################
	checkResult = 'NO'
	buses, ids, statuses, loads = FindAllLoadData()
	
	for bus, id, status, load in zip(buses, ids, statuses, loads):
		if bus == loadbus and id.strip(" ") == loadid:
			checkResult = "YES"
			 
	return checkResult

def getLoadData(loadbus, loadid):
	buses, ids, statuses, loads = FindAllLoadData()
	# print buses, ids, statuses, loads
	# raw_input()
	# print ids
	for bus, id, status, load in zip(buses, ids, statuses, loads):
		# print bus, id
		# raw_input()
		if bus == loadbus and id.strip(" ") == loadid:
			# print bus , id, status, load.real
			# raw_input()
			return status, load.real, load.imag
			# return 0, 0, 0
	print loadbus, loadid, "Loadbus/id Not Found"
	raise 
	return 0, 0, 0

def UpdateLoad(loadbus, loadid, status, pload, qload):
	 
	if pload == 0:
		loadStatus = checkLoadExistence(loadbus, loadid)
		if loadStatus == "YES":
			psspy.progress ("\n %s, %s, %s, %s, %s\n" %(loadbus, loadid, status, pload, qload))
			err = psspy.load_chng_4(loadbus, loadid, [status, _i,_i,_i,_i,_i], [pload, qload, _f, _f,_f,_f])
			# UpdateLoad(loadbus, loadid, status, pload, qload)
		else:
			print "Load ", loadbus, "-", loadid, " NOT FOUND in case... but Pload=0 so ignored"
			# raw_input()
			psspy.progress("\n %s-%s Load not found in case... but Pload=0 so ignored" %(loadbus, loadid))
	else:
		loadStatus = checkLoadExistence(loadbus, loadid)
		if loadStatus == "YES":
			psspy.progress ("\n %s, %s, %s, %s, %s\n" %(loadbus, loadid, status, pload, qload))
			err = psspy.load_chng_4(loadbus, loadid, [status, _i,_i,_i,_i,_i], [pload, qload, _f, _f,_f,_f])
			# UpdateLoad(loadbus, loadid, status, pload, qload)
		else:
			print "Load ", loadbus, "-", loadid, " NOT FOUND in case...RAISE ERROR"
			print "Load not found in case... Raise Error"
			psspy.progress("\n %s-%s Load not found in case... Raise Error" %(loadbus, loadid))
			# raise ValueError
			raise MissingElementError(" -- Load Not Found in Topology")
	
	# if loadbus != skTie_bus:
		# if pload == 0:
			# status = 0
		# else:
			# status = 1
		
	
	
	
	
	


###### Determining MPID Net Flow
def FindAllFlowData(sid = -1, ties = 1, flag = 2):
	err, [busesFrom, busesTo, statuses] = psspy.aflowint(sid, 1, ties, flag, ("FROMNUMBER", "TONUMBER", "STATUS"))
	err, [ids] = psspy.aflowchar(sid, 1, ties, flag, ("ID",))
	err, [pflows, plosses] = psspy.aflowreal(sid, 1, ties, flag, ("P", "PLOSS"))
	
	return busesFrom, busesTo, statuses, ids, pflows, plosses

def getBranchFlow(fromBus, toBus, ID, direction="positive"):
	busesFrom, busesTo, statuses, ids, pflows, plosses = FindAllFlowData()
	for (busFrom, busTo, status, id, pflow, ploss) in zip(busesFrom, busesTo, statuses, ids, pflows, plosses):
		temp = []
		# if busFrom == fromBus and busTo == toBus:
		if busFrom == fromBus and busTo == toBus and id.strip(" ") == ID:
			# temp.append(id)
			# temp.append(ID)
			# print temp
			# raw_input()
		
			if direction == "positive":
				print status, pflow, ploss
				# raw_input()
				return  status, pflow, ploss
			else:
				print status, pflow, ploss
				# raw_input()
				return  status, -pflow, ploss
	
	print "Branch Not Found"
	raise ValueError

def get3WBranchFlow(fromBus, toBus, ID, direction="positive"):
	busesFrom, busesTo, statuses, ids, pflows, plosses = FindAllFlowData()
	for (busFrom, busTo, status, id, pflow, ploss) in zip(busesFrom, busesTo, statuses, ids, pflows, plosses):
		temp = []
		# if busFrom == fromBus and busTo == toBus:
		if busFrom == fromBus and busTo > toBus and id.strip(" ") == ID:
		# if busFrom == fromBus and id.strip(" ") == ID:
			if direction == "positive":
				print status, pflow, ploss
				# raw_input()
				return  status, pflow, ploss
			else:
				print status, pflow, ploss
				# raw_input()
				return  status, -pflow, ploss
	
	print "Branch Not Found"
	raise ValueError
	
	
	


###############################
#############################################
##############################################################

def determine_max_availablePower_EMMO(currentHourEMMO, mpidName):
	total_available_power=0
	for eachrow in currentHourEMMO:
		if eachrow.assetName == mpidName:
			total_available_power += eachrow.availablePower
	return total_available_power
			
			
			
			

# ProcessFiles(caseFiles, GenMappingFiles, EMMOFiles, loadDataFiles, loadMappingFiles, tssDataFiles, grossLoadDataFiles, dates, months, Selected_Lf_Process)	

def ProcessFiles(caseFiles, GenMappingFiles, EMMOFiles, loadDataFiles, loadMappingFiles, tssDataFiles, grossLoadDataFiles, dates, months, Selected_Lf_Process, manualTopologyCaseFile):
	intertie = ab_bc
	##voltageLimits = ReadVoltageLimits(voltageFilename)
	wb = xlwt.Workbook()
	monthlyMPIDMapping = dict()
	monthlyCases = dict()
	monthlyLoadMapping = dict()
	monthlyEMMO = dict()
	monthlyLoad = dict()
	monthlyMvarLoad = dict()
	monthlyTSS = dict()
	monthlyGrossLoad = dict()
	monthlyGrossLoadCriteriaCheck = dict()
	
	timeNow = datetime.datetime.now()
	timeNow = timeNow.strftime("%d%b%Y-%H-%M")
	print "Simulation Start Time : ", timeNow
	############# State-1 Folder ....
	S1outDir = "State-1 -%s" %timeNow
	ensure_dir(S1outDir)
	############# State-1 Cases Folder ....
	S1CaseoutDir = "State-1 Cases -%s" %timeNow
	ensure_dir(S1CaseoutDir)
	
	unknownErrorlogfilename = os.path.join(S1outDir, "Unknown Error Log_%s.log" %timeNow)
	unknownErrorlog = open(unknownErrorlogfilename, "w")
	unknownErrorlog.write("\tStart Time = %s\n" %timeNow)
	
	############### S1 Marginal Unit Logfile Folders .....
	S1MULogDir = "State-1 Marginal Unit Logfiles"
	ensure_dir(S1MULogDir)
	S1MULogFileName = os.path.join(S1MULogDir, "S1_MU_Log_%s.log" %timeNow)
	S1_MULog = open(S1MULogFileName, "w")
	S1_MULog.write("HOUR	MU_NAME	MU_SERIAL	MU_BLOCK	MU_Offerprice	MU_AvailablePower	MarginalUnitReserve	S1_OWSP	s1_OESP	S1_WATL	S1_EATL	TOTAL_LOAD(EXPORT EXCLUDED)	TOTAL_GEN(BC_EXCLUDED)	BTF Gen/Load (To be Excluded)	TOTAL_LOSS	IE_flows[bc_imp]	IE_flows[bc_exp]	IE_flows[sk_imp]	IE_flows[sk_exp]	IE_flows[mt_imp]	IE_flows[mt_exp]	Total_currentHourExports_MW\n\n")
	
	
	################ S1 Error Log File/Folder .....................
	S1ErrorLogDir = "State-1 Error Logfiles"
	ensure_dir(S1ErrorLogDir)
	S1_errorlogname = os.path.join(S1ErrorLogDir, "S1_ErrorLog_%s.log" %timeNow)
	state1_errorlog = open(S1_errorlogname, "w")
	############ S1 EMMO Log Files .............
	hourlyEMMOlogDir = "State-1 EMMO Logfiles"
	ensure_dir(hourlyEMMOlogDir)
	# S1MULogFileName = os.path.join(S1MULogDir, "S1_MU_Log_%s.log" %timeNow)
	# S1_MULog = open(S1MULogFileName, "w")
	emmoupdateRow = 1
	## Initializing PSSE .....
	print "=================================##############################"
	print "Initializing PSSE ....."
	psspy.psseinit(100000)
	print "=================================##############################"
	##############################
		
	for month in months:
		logfilename = os.path.join(os.getcwd(), month+ "-%s.log" %timeNow)
		global log_month
		log_month = open(logfilename, "w")
		
		## Enable/Disable Printing :::::
		enable_print()
		# log_print(log_month)		
		##############	Select Monthly Gen Mapping ############
		GenMappingFile = selectMonthlyMPIDMapping(GenMappingFiles, month)
		monthlyMPIDMapping[month] = CreateMPIDs(GenMappingFile, month)
		#####	Select Monthly Cases ############
		monthlyCases[month] = selectMonthlyCase(caseFiles, month)
		## Select Monthly Load Mapping ##############
		#############################################
		# loadMappingFile = SelectMonthlyLoadMapping(loadMappingFiles, month)
		# monthlyLoadMapping[month] = readLoadMapping(loadMappingFile)
		loadMappingFile = GenMappingFile
		monthlyLoadMapping[month] = readLoadMapping(loadMappingFile)
		#### Select EMMO ####
		EMMOFile = SelectMonthlyEMMO(EMMOFiles, month)
		monthlyEMMO[month] = readMonthlyEMMO(EMMOFile)
		###### Select Monthly load Data ##
		loadDataFile = SelectMonthlyLoad(loadDataFiles, month)
		monthlyLoad[month] = readMonthlyLoad(loadDataFile)
		###### Select Monthly load Mvar Data ##
		monthlyMvarLoad[month] = readMonthly_MvarLoad(loadDataFile)
		### Select Monthly TSS Data ####
		tssDataFile = SelectMonthlyTSS(tssDataFiles, month)
		monthlyTSS[month] = readMonthlyTSS(tssDataFile)
		###	Select Monthly Gross Load
		grossLoadDataFile = SelectMonthlyGrossLoad(grossLoadDataFiles, month)
		monthlyGrossLoad[month], monthlyGrossLoadCriteriaCheck[month] = readMonthlyGrossLoad(grossLoadDataFile)
	## raw_input()
	count_success_s1 = 0
	count_attemptedCases = 0
	for dt in dates:
		## Read dates and split them into year, month, day, hour, mins ::::
		# dates = ["2015-DEC-01-14-00", "2015-DEC-01-03-00"]
		date = dt.strftime("%Y-%b-%d-%H-%M")
		log_date_time = dt.strftime("%Y/%m/%d %H:%M")
		
		year = date.split("-")[0]
		month = date.split("-")[1].upper()
		day = date.split("-")[2]
		hour = date.split("-")[3]
		min = date.split("-")[4]
		## Customize year for EMMO and Forecast and Module-C calculation
		year_2 = str(int(year)-2)
		
		
		year_stripped = year.split('20')[1]
		# year_emmo = year
		
		## Select LF Process :: Forecast or Module-C
		if Selected_Lf_Process == "Forecast":
			if year != "2018" :
				time_emmo = day+month+year[2:]+":"+hour+":00:00"
			else:
				time_emmo = day+month+year+":"+hour+":00:00"
			time_tss = day+month+year_2+":"+hour+":00:00"
				
				
		else:
			time_emmo = day+month+year[2:]+":"+hour+":00:00"
			time_tss = day+month+year+":"+hour+":00:00"
		
		
			
		################## State-1 Hourly Output Directory
		hourlyS1outDir = os.path.join(S1outDir, day+"_"+month+"_"+year)
		ensure_dir(hourlyS1outDir)
		######### Enable/Disable Printing :::::
		enable_print()
		###############################################################
		
		print "Processing : " , date, "  Attempted : ", count_attemptedCases, "  Success : ", count_success_s1
		################# Print Log File ####################################
		logfilename = os.path.join(S1outDir, "PrintLog_"+day+"_"+month+"_"+year+"_Hour_"+hour+".log")
		global log
		log = open(logfilename, "w")
		log_print(log)
		## Create hourly basecase name
		tempcasename = day+"_"+month+"_"+year+"_Hour_"+hour+".sav"
		outputCaseName = os.path.join(hourlyS1outDir, tempcasename)
		print outputCaseName
		
		######################### Hourly EMMO Log File Names
		hourlyEMMOlogfilename = os.path.join(hourlyEMMOlogDir, "S1_EMMOLog_"+day+"_"+month+"_"+year+"_Hour_"+hour+".log")
		
		###################################### Process hourly files ::::
		try:
			## Read Hourly TSS ::::
			currentHourTSS = createHourlyTSS(monthlyTSS[month], time_tss)
			## Change time format for load data and gross load data files ::
			time_load = day+month+year+":"+hour+":00:00"
			## Read Hourly Load Data::::
			currentHourLoad = createHourlyLoad(monthlyLoad[month], time_load)
			## Read Hourly Gross Load Data::::
			currentHourGrossLoad = createHourlyGrossLoad(monthlyGrossLoad[month], time_load)
			## Read Hourly Gross Load Data Criteria Check::::
			currentHourGrossLoadCriteriaCheck = createHourlyGrossLoadCriteriaCheck(monthlyGrossLoadCriteriaCheck[month], time_load)
			## Read Hourly Gross Load MVar Data::::
			currentHourMvarLoad = createHourlyMvarLoad(monthlyMvarLoad[month], time_load)
			## Read Monthly Topology Basecase Name ::
			
			topology_caseFilename = monthlyCases[month]
			MPIDs = monthlyMPIDMapping[month]
			loadMapping = monthlyLoadMapping[month]
			## Read Hourly EMMO ::::
			currentHourEMMO, currentHourExports, Total_currentHourExports_MW = createHourlyEMMO(monthlyEMMO[month], time_emmo, currentHourLoad,  currentHourGrossLoadCriteriaCheck, MPIDs)
			
			# loadData = currentHourLoad
			# grossloaddata = currentHourGrossLoad
			
			if len(currentHourEMMO) != 0:
				# MOList = correctEMMO(currentHourEMMO, loadData, MPIDs)
				# print "Continue..."
				MOList = currentHourEMMO
			else:
				print "EMMO Data not found"
				raise MissingDataError("EMMO - Before Processing Case Phase")
				
			# loadMvarData = currentHourMvarLoad
			# tssData = currentHourTSS
			###############################################################
			
			###############################################################
			count_attemptedCases += 1
			
			##################################################################
			### First Hour Case is created from the monthly topology case ....
			# previousCase = topology_caseFilename
			if manualTopologyCaseFile != r"":
				previousCase = manualTopologyCaseFile
				manualTopologyCaseFile = ''
			else:
				if count_success_s1 == 0:
					previousCase = topology_caseFilename
				
				
			# enable_print()
			# log_print(log)
			print "Topology Case Selected : ", previousCase
			
			
			case = Case(previousCase, ab_bc, monthlyMPIDMapping[month], currentHourEMMO, currentHourLoad, currentHourGrossLoad, currentHourMvarLoad, monthlyLoadMapping[month], currentHourTSS, outputCaseName, month, day, year, hour, currentHourExports, Total_currentHourExports_MW)
			
			try:
				previousCase, emmoUpdateList, MarginalUnit, savedOWSP, savedOESP, newWATL, newEATL, Load, Gen, Loss, initial_btfGen_dispatched = case.ProcessMPID()
				S1_MULog.write("\n")
				S1_MULog.write(tempcasename + "\t%s"*21 %(MarginalUnit.assetName, MarginalUnit.serial, int(MarginalUnit.blockNumber), float(MarginalUnit.offerPrice), float(MarginalUnit.availablePower), case.MarginalUnitReserve, savedOWSP, savedOESP, newWATL, newEATL, Load, Gen, initial_btfGen_dispatched, Loss, case.IE_flows[bc_imp], case.IE_flows[bc_exp], case.IE_flows[sk_imp], case.IE_flows[sk_exp], case.IE_flows[mt_imp], case.IE_flows[mt_exp], case.Total_currentHourExports_MW))
				
				write_hourlyEMMOlogfile(hourlyEMMOlogfilename, case.currentHourEMMO)
				
				count_success_s1 += 1
					
			except iterationLimitError as e:
				# errorlog.write(tempcasename + "\tMismatch = %s\tIterations = %s\n" %(e.mismatch, e.iterationNumber))
				state1_errorlog.write(log_date_time + "\tXA-UNSOL1\t" + "%s\t%s\t%s\n" %(e.load_AIES, e.gen_AIES, e.loss_total_AIES))
				pass
			except solutionError as s:
				# errorlog.write(tempcasename + "\tSolution Error = %s\n" %(s.solvedMsg))
				state1_errorlog.write(log_date_time + "\tXA-UNSOL1\t" + "%s\t%s\t%s\n" %(s.load_AIES, s.gen_AIES, s.loss_total_AIES))
				pass
			except HvdcError as s:
				# errorlog.write(tempcasename + "\tSolution Error in HVDC\n")
				state1_errorlog.write(log_date_time + "\tXA-UNSOL1\t" + "%s\t%s\t%s\n" %(s.load_AIES, s.gen_AIES, s.loss_total_AIES))
				pass
			except InsufficientSourceError as s:
				# errorlog.write(tempcasename + "\tInsufficient Source Asset\n")
				state1_errorlog.write(log_date_time + "\tXA-INSUF1\t" + "%s\t%s\t%s\t%s\n" %(s.load_AIES, s.gen_AIES, s.loss_total_AIES, s.comment))
				print s.comment
				# raise 
				pass
			# except:
				# unknownErrorlog.write(tempcasename + " Unknown Error\n")
				# state1_errorlog.write(log_date_time + "\tXA-UNSOL1\n")
				# # errorlog.write(tempcasename + " Unknown Error\n")
				# # state1_errorlog.write(tempcasename + " Unknown Error\n")
				# # state1_errorlog.write(log_date_time + "\tXA-UNSOL1\n" + "%s\t%s\t%s\n" %(s.load_AIES, s.gen_AIES, s.loss_total_AIES))
				# pass
		
		except MissingDataError as m:
			# errorlog.write(tempcasename + "\tMissing Data\t" + "%s\n" %(m.missingDataTag))
			state1_errorlog.write(log_date_time + "\tXA-MISSIN\t" + "%s\n" %(m.missingDataTag))
			enable_print()
			print m
			# raise 
			pass
		except MissingElementError as m:
			# errorlog.write(tempcasename + "\tMissing Data\t" + "%s\n" %(m.missingElementTag))
			state1_errorlog.write(log_date_time + "\tXA-MISSIN\t" + "%s\n" %(m.missingElementTag))
			pass
		
	enable_print()
	timeNow = datetime.datetime.now()
	timeNow = timeNow.strftime("%d%b%Y-%H-%M")
	unknownErrorlog.write("\tStop Time = %s\n" %timeNow)
	# basecasepreplog.write("\tStop Time = %s\n" %timeNow)
	# basecasepreplog.write("\tNo of Successful S1 Cases = %s\n" %count_success_s1)
	print " =============== No of Successful S1 Cases : ", count_success_s1
	# errorlog.close()
	S1_MULog.close()
	import CollectState1Files
	CollectState1Files.collectmain(S1outDir, S1CaseoutDir)
	

	
def write_hourlyEMMOlogfile(hourlyEMMOlogfilename, MOList):
	# global hourlyEMMOlogfile
	hourlyEMMOlogfile = open(hourlyEMMOlogfilename, "w")
	
	# fileName = "Log_EMMO_Adjusted - " + tag + ".txt"
	# EMMO_Log_Modified = open(fileName, "w")
	hourlyEMMOlogfile.write("time	serial	assetName	relatedImportAsset	assetShortName	Import_Export	blockNumber	flexibility	offerPrice	blockSize	availablePower	dispatchedPower	capabilityMW	totalDisp_eachMPID	P_export	P_import	P_netImportExport	emmoOffer	loadOffer	CriteriaCheckDecision	deductibleNTGLoad	reduceLoadTag	finalNTGLoad	P_export_dict[bc]	P_import_dict[bc]	P_netImportExport_dict[bc]	P_prev_netImportExport_dict[bc]	P_export_dict[sk]	P_import_dict[sk]	P_netImportExport_dict[sk]	P_prev_netImportExport_dict[sk]	P_export_dict[mt]	P_import_dict[mt]	P_netImportExport_dict[mt]	P_prev_netImportExport_dict[mt]")
	for mUnit in MOList:
		# print mUnit.time, mUnit.serial, mUnit.assetName, mUnit.relatedImportAsset, mUnit.assetShortName, mUnit.Import_Export, mUnit.blockNumber, mUnit.flexibility, mUnit.offerPrice, mUnit.blockSize, mUnit.availablePower, mUnit.dispatchedPower, mUnit.capabilityMW, mUnit.totalDisp_eachMPID, mUnit.P_export, mUnit.P_import, mUnit.P_netImportExport
		
		hourlyEMMOlogfile.write("\n")
		hourlyEMMOlogfile.write("%s\t"*35 %(mUnit.time, mUnit.serial, mUnit.assetName, mUnit.relatedImportAsset, mUnit.assetShortName, mUnit.Import_Export, mUnit.blockNumber, mUnit.flexibility, mUnit.offerPrice, mUnit.blockSize, mUnit.availablePower, mUnit.dispatchedPower, mUnit.capabilityMW, mUnit.totalDisp_eachMPID, mUnit.P_export, mUnit.P_import, mUnit.P_netImportExport, mUnit.emmoOffer, mUnit.loadOffer, mUnit.CriteriaCheckDecision, mUnit.deductibleNTGLoad, mUnit.reduceLoadTag, mUnit.finalNTGLoad, 
		mUnit.P_export_dict[bc], mUnit.P_import_dict[bc], mUnit.P_netImportExport_dict[bc], mUnit.P_prev_netImportExport_dict[bc], 
		mUnit.P_export_dict[sk], mUnit.P_import_dict[sk], mUnit.P_netImportExport_dict[sk], mUnit.P_prev_netImportExport_dict[sk], 
		mUnit.P_export_dict[mt], mUnit.P_import_dict[mt], mUnit.P_netImportExport_dict[mt], mUnit.P_prev_netImportExport_dict[mt]))
		# EMMO_Log_Modified.write("\n")
					
	hourlyEMMOlogfile.close()
	
	
	
def writeEmmoUpdate(date, emmoUpdateList, emmoUpdateWB, emmoUpdateWS, emmoupdateRow, MarginalUnit):
	row = emmoupdateRow
	
	# date = dt.strftime("%d%b%Y:%H:%M")
	year = date.split("-")[0]
	# year_2 = str(int(year)-2)
	month = date.split("-")[1].upper()
	day = date.split("-")[2]
	hour = date.split("-")[3]
	min = date.split("-")[4] 
	# time = day+month+year_2+":"+hour+":00:00"
	
	year_2 = str(int(year)-2)
	# time = day+month+year_2+":"+hour+":00:00"
	year_2_emmo = year_2.split('20')[1]
	time_emmo = day+month+year_2_emmo+":"+hour+":00:00"
	for eachRecord in emmoUpdateList:
		if emmoUpdateList[eachRecord][0] <= MarginalUnit.serial:
			row += 1
			emmoUpdateWS["A"+str(row)] = time_emmo
			# emmoUpdateWS["B"+str(row)] = eachRecord[0]
			emmoUpdateWS["B"+str(row)] = eachRecord
			emmoUpdateWS["C"+str(row)] = emmoUpdateList[eachRecord][1]
			emmoUpdateWS["D"+str(row)] = emmoUpdateList[eachRecord][2]
			emmoUpdateWS["E"+str(row)] = emmoUpdateList[eachRecord][3]
	
	emmoUpdateWB.save("EMMO Correction %s.xlsx" %month)
	return row

class InsufficientSourceError(Exception):
	def __init__(self, load_AIES, gen_AIES, loss_total_AIES, comment):
		print "INSUFFICIENT SOURCE ASSET"
		self.load_AIES = load_AIES
		self.gen_AIES = gen_AIES
		self.loss_total_AIES = loss_total_AIES
		self.comment = comment

class MissingDataError(Exception):
	def __init__(self, missingDataTag):
		print "MISSING DATA", missingDataTag
		self.missingDataTag = missingDataTag

class MissingElementError(Exception):
	def __init__(self, missingElementTag):
		print "MISSING ELEMENT", missingElementTag
		self.missingElementTag = missingElementTag
	 
		
class iterationLimitError(Exception):
	def __init__(self, mismatch, iterationNumber, load_AIES, gen_AIES, loss_total_AIES):
		self.iterationNumber = iterationNumber
		self.mismatch = mismatch
		self.load_AIES = load_AIES
		self.gen_AIES = gen_AIES
		self.loss_total_AIES = loss_total_AIES

class solutionError(Exception):
	def __init__(self, solvedMsg, load_AIES, gen_AIES, loss_total_AIES):
		self.solvedMsg = solvedMsg
		self.load_AIES = load_AIES
		self.gen_AIES = gen_AIES
		self.loss_total_AIES = loss_total_AIES
		

class HvdcError(Exception):
	def __init__(self, load_AIES, gen_AIES, loss_total_AIES):
		print "HVDC ERROR"
		self.load_AIES = load_AIES
		self.gen_AIES = gen_AIES
		self.loss_total_AIES = loss_total_AIES
#####################
#############################
def selectMonthlyMPIDMapping(GenMappingFiles, month):
	print "Selecting Month Gen Mapping .... "
	desiredFile = ''
	for excelFile in GenMappingFiles:
		filename = os.path.splitext(os.path.split(excelFile)[1])[0].lower()
		filename = filename.split("_")[2]
		if month.lower() in filename:
			desiredFile = excelFile
	# print desiredFile, month
	# raw_input()
	return desiredFile	

def CreateMPIDs(excelFile, month): ## Updated by SDR
	print ("Reading Gen Mapping .....")
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name('Gen MPID Mapping') ## Updated
	MPIDs = []
	MPIDs_dict = dict()
	for row in range(1, ws.nrows):
		# tag = ws.cell(row, 2).value   ### Clumn C
		lfTag = str(ws.cell(row, col2num("C")).value)   ### Clumn C
		
		# if tag == 'LF MPID' or tag == 'LF MPID-SKIP' or tag == 'SKIP':
		# if tag == 'LF' or tag == 'SKIP-LF':
		
		mpidName = str(ws.cell(row, col2num("A")).value)   ### Clumn B
		# print mpidName
		facilityName = str(ws.cell(row, col2num("B")).value)   ### Clumn B
		lfTag = str(ws.cell(row, col2num("C")).value)   ### Clumn B
		loadmpidNames  = str(ws.cell(row, col2num("D")).value)   ### Clumn B
		
		emmoOffer  = str(ws.cell(row, col2num("E")).value)   ### Clumn E
		loadOffer  = str(ws.cell(row, col2num("F")).value)   ### Clumn F
		
		locationType  = str(ws.cell(row, col2num("G")).value)   ### Clumn G
		# dosTag  = str(ws.cell(row, col2num("H")).value)   ### Clumn H
		
		# ISDtag = ws.cell(row, col2num("F")).value   ### Clumn C
		
		# associatedGens = [str(ws.cell(row, col).value) for col in range(6, 17)]
		associatedGens = [str(ws.cell(row, col).value) for col in range(col2num("H"), col2num("R")+1)]
		# associatedLoads = [str(ws.cell(row, col).value) for col in range(17, 20)]
		associatedLoads = [str(ws.cell(row, col).value) for col in range(col2num("S"), col2num("U")+1)]
		
		loadDistributionFactor  = ws.cell(row, col2num("V")).value
		
		listedLoadElements = []
		# if associatedLoads != []:
		for loads in associatedLoads:
			if loads != "":
				temploads = loads.split(";")
				for tempload in temploads:
					tempload = tempload.strip("[")
					tempload = tempload.strip("]")
					listedLoadElements.append(tempload)
		# print listedLoadElements	
		
		loadmpids = []
		if loadmpidNames != '':
			# print loadmpidNames
			loadmpidNames = loadmpidNames.replace(" ", "")
			# print loadmpidNames
			loadmpids = loadmpidNames.split(",")
			# print loadmpids
		onsiteLoads = dict()
		for (loadmpid, loadElement)  in zip(loadmpids, listedLoadElements):
			if loadmpid != "":
				onsiteLoads[loadmpid] = loadElement.split(",")
			
		# print onsiteLoads
		# enable_print()
		# print loadmpids
		# raw_input()

		
		interfaceBus = (ws.cell(row, col2num("W")).value)
		if interfaceBus != '':
			interfaceBus = int(interfaceBus)
		mpid_subsystem = str((ws.cell(row, col2num("X")).value))
		buses = mpid_subsystem.split(",")
		netFlow = str((ws.cell(row, col2num("Y")).value))
		
		generators = []
		# if associatedGens != []:
		for gen in associatedGens:
			if gen != '':
				[bus, id] = gen.split("-")
				bus = int(bus)
				generators.append(generatorObject(bus, str(id)))
		
		
		MPID_buses = []
		for bus in buses:
			if bus != '':
				MPID_buses.append(int(bus.strip(" ")))
		if interfaceBus != '':
			MPID_buses.append(interfaceBus)
		# print mpidName, tag, ISDtag
		# print associatedGens
		# print associatedLoads 
		# print interfaceBus
		# print MPID_buses
		# print netFlow 
		# raw_input()
		temp = MPID(mpidName, facilityName, lfTag, loadmpids, emmoOffer, loadOffer, locationType, generators, onsiteLoads, loadDistributionFactor, interfaceBus, MPID_buses, netFlow )
		MPIDs.append(temp)
		# MPIDs_dict[mpidName] = temp
	# sys.exit()    
			
	return MPIDs
	

def CreateMPIDs_v1(excelFile, month): ## Updated by SDR
	
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name('Gen MPID Mapping') ## Updated
	MPIDs = []
	for row in range(1, ws.nrows):
		# tag = ws.cell(row, 2).value   ### Clumn C
		tag = str(ws.cell(row, col2num("C")).value)   ### Clumn C
		# if tag == 'LF MPID' or tag == 'LF MPID-SKIP' or tag == 'SKIP':
		if tag == 'LF' or tag == 'SKIP-LF':
			mpidName = str(ws.cell(row, col2num("A")).value)   ### Clumn B
			facilityName = str(ws.cell(row, col2num("B")).value)   ### Clumn B
			lfTag = str(ws.cell(row, col2num("C")).value)   ### Clumn B
			loadmpidNames  = str(ws.cell(row, col2num("D")).value)   ### Clumn B
			
			emmoOffer  = str(ws.cell(row, col2num("E")).value)   ### Clumn E
			loadOffer  = str(ws.cell(row, col2num("F")).value)   ### Clumn F
			
			locationType  = str(ws.cell(row, col2num("G")).value)   ### Clumn G
			# dosTag  = str(ws.cell(row, col2num("H")).value)   ### Clumn H
			
			# ISDtag = ws.cell(row, col2num("F")).value   ### Clumn C
			
			# associatedGens = [str(ws.cell(row, col).value) for col in range(6, 17)]
			associatedGens = [str(ws.cell(row, col).value) for col in range(col2num("H"), col2num("R")+1)]
			# associatedLoads = [str(ws.cell(row, col).value) for col in range(17, 20)]
			associatedLoads = [str(ws.cell(row, col).value) for col in range(col2num("S"), col2num("U")+1)]
			loadDistributionFactor  = (ws.cell(row, col2num("V")).value)

			
			interfaceBus = (ws.cell(row, col2num("W")).value)
			if interfaceBus != '':
				interfaceBus = int(interfaceBus)
			mpid_subsystem = str((ws.cell(row, col2num("X")).value))
			buses = mpid_subsystem.split(",")
			netFlow = str((ws.cell(row, col2num("Y")).value))
			
			generators = []
			# if associatedGens != []:
			for gen in associatedGens:
				if gen != '':
					[bus, id] = gen.split("-")
					bus = int(bus)
					generators.append(generatorObject(bus, str(id)))
			
			listedLoadElements = []
			# if associatedLoads != []:
			for loads in associatedLoads:
				temploads = loads.split(";")
				for tempload in temploads:
					tempload = tempload.strip("[")
					tempload = tempload.strip("]")
					listedLoadElements.append(tempload)
			print listedLoadElements	
			
			loadmpids = []
			loadmpidNames = loadmpidNames.strip(" ")
			loadmpids = loadmpidNames.split(",")
			
			onsiteLoads = dict()
			for (loadmpid, loadElement)  in zip(loadmpids, listedLoadElements):
				onsiteLoads[loadmpid] = loadElement,split("'")
				
			print onsiteLoads
			# enable_print()
			# print loadmpids
			raw_input()
			MPID_buses = []
			for bus in buses:
				if bus != '':
					MPID_buses.append(int(bus.strip(" ")))
			if interfaceBus != '':
				MPID_buses.append(interfaceBus)
			# print mpidName, tag, ISDtag
			# print associatedGens
			# print associatedLoads 
			# print interfaceBus
			# print MPID_buses
			# print netFlow 
			# raw_input()
			temp = MPID(mpidName, facilityName, tag, loadmpids, emmoOffer, loadOffer, locationType, generators, onsiteLoads, loadDistributionFactor, interfaceBus, MPID_buses, netFlow )
			MPIDs.append(temp)
	# sys.exit()    
			
	return MPIDs 
###################################################
#####################################	

	
def CreateMPIDs_v0(excelFile, month): ## Updated by SDR
	
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name('Gen MPID Mapping') ## Updated
	MPIDs = []
	for row in range(1, ws.nrows):
		tag = ws.cell(row, 2).value   ### Clumn C
		# if tag == 'LF MPID' or tag == 'LF MPID-SKIP' or tag == 'SKIP':
		if tag == 'LF MPID' or tag == 'LF MPID-SKIP':
			mpidName = str(ws.cell(row, col2num("B")).value)   ### Clumn B
			loadmpidNames  = str(ws.cell(row, col2num("E")).value)   ### Clumn B
			ISDtag = ws.cell(row, col2num("F")).value   ### Clumn C
			associatedGens = [str(ws.cell(row, col).value) for col in range(6, 17)]
			associatedLoads = [str(ws.cell(row, col).value) for col in range(17, 20)]
			interfaceBus = (ws.cell(row, col2num("V")).value)
			if interfaceBus != '':
				interfaceBus = int(interfaceBus)
			mpid_subsystem = str((ws.cell(row, col2num("W")).value))
			buses = mpid_subsystem.split(",")
			netFlow = str((ws.cell(row, col2num("Y")).value))
			# print 
			# print mpidName, tag, ISDtag
			# print associatedGens
			# print associatedLoads 
			# print interfaceBus
			# print buses
			# print netFlow 
			# raw_input()
			
			generators = []
			# if associatedGens != []:
			for gen in associatedGens:
				if gen != '':
					[bus, id] = gen.split("-")
					bus = int(bus)
					generators.append(generatorObject(bus, str(id)))
			
			loads = []
			# if associatedLoads != []:
			for load in associatedLoads:
				if load != '':
					[bus, id] = load.split("-")
					bus = int(bus)
					loads.append(loadObject(bus, id))
			
			loadmpids = []
			loadmpidNames = loadmpidNames.strip(" ")
			loadmpids = loadmpidNames.split(", ")
			# enable_print()
			# print loadmpids
			# raw_input()
			MPID_buses = []
			for bus in buses:
				if bus != '':
					MPID_buses.append(int(bus.strip(" ")))
			if interfaceBus != '':
				MPID_buses.append(interfaceBus)
			# print mpidName, tag, ISDtag
			# print associatedGens
			# print associatedLoads 
			# print interfaceBus
			# print MPID_buses
			# print netFlow 
			# raw_input()
			temp = MPID(mpidName, loadmpids, tag, ISDtag, generators, loads, interfaceBus, MPID_buses, netFlow )
			MPIDs.append(temp)
	# sys.exit()    
			
	return MPIDs 
	
###################################################
#####################################
###########
def selectMonthlyCase(caseFiles, month):
	print "Selecting Monthly Topology Case ... "
	desiredMonthlyCase = ''
	for caseFile in caseFiles:
		filename = os.path.splitext(os.path.split(caseFile)[1])[0].lower()
		filename = filename.split("_")[1]
		if month.lower() in filename:
			desiredMonthlyCase = caseFile
		
		# if month.lower() in os.path.splitext(os.path.split(caseFile)[1])[0].lower():
			# desiredMonthlyCase = caseFile
			
	return desiredMonthlyCase	


########################################################
####################################################
def SelectMonthlyLoadMapping(loadMappingFiles, month):
	#########################
	######### Not Being Used Anymore#######
	##########################
	print "Selecting Monthly Load Mapping ... "
	desiredFile = ''
	for excelFile in loadMappingFiles:
		filename = os.path.splitext(os.path.split(excelFile)[1])[0].lower()
		filename = filename.split("_")[2]
		if month.lower() in filename:
			desiredFile = excelFile
		# if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			# desiredFile = excelFile
			
	return desiredFile
	
class loadmapdata(object):
	def __init__(self, genMPID, loadMPID, bus, id, siteType, loadDistributionFactor):
		self.genMPID = genMPID
		self.loadMPID = loadMPID
		self.bus = bus
		self.id = id
		# self.isdtag = isdtag
		self.siteType = siteType
		self.loadDistributionFactor = loadDistributionFactor
		
def readLoadMapping(excelFile):
	print "Reading Load Mapping File .... "
	wb = xlrd.open_workbook(excelFile)
	# ws = wb.sheet_by_name("Load Mapping (Review)")
	ws = wb.sheet_by_name("Load Mapping")
	loadMappingList = []
	for row in range(1, ws.nrows):
		# genMPID = (ws.cell(row, 0).value)
		# if type(genMPID) is float or type(genMPID) is int:
			# genMPID = str(int(genMPID))
		# else:
			# genMPID = str(genMPID)
		genMPID = ''
		loadMPID = (ws.cell(row, col2num("A")).value)
		if type(loadMPID) is float or type(loadMPID) is int:
			loadMPID = str(int(loadMPID))
		else:
			loadMPID = str(loadMPID)
		
		# if type(mpidName) is float or type(mpidName) is int:
			# mpidName = str(int(mpidName))
		# print loadMPID
		# raw_input()
		if loadMPID != '':
			bus = ws.cell(row, col2num("B")).value
			# enable_print()
			# print ws.cell(row, 2).value
			# raw_input()
			# print type(bus)
			bus = int(bus)
			# print type(bus)
			# print bus
			# raw_input()
			
			if type(bus) is str:
				bus = int(float(bus))
			elif type(bus) is float:
				bus = int(bus)
			
			# bus = int(str(ws.cell(row, 2).value))
			id = (ws.cell(row, col2num("C")).value)
			# print id, type(id)
			if type(id) is  float:
				id = str(int(id))
			elif type(id) is  int:
				id = str(id)
			else: ## type(id) is  unicode:
				id = str(id)
			siteType = (ws.cell(row, col2num("D")).value)
			
			loadDistributionFactor = (ws.cell(row, col2num("E")).value)
			if loadDistributionFactor != '':
				loadDistributionFactor = float(loadDistributionFactor)
			else:
				loadDistributionFactor = 1.0
			# print loadMPID, bus, id
			# raw_input()
			loadMappingList.append(loadmapdata(genMPID, loadMPID, bus, id, siteType, loadDistributionFactor))
	# raw_input()
	return loadMappingList

		
def readLoadMapping_v0(excelFile):
	wb = xlrd.open_workbook(excelFile)
	# ws = wb.sheet_by_name("Load Mapping (Review)")
	ws = wb.sheet_by_name("Load Mapping")
	loadMappingList = []
	for row in range(1, ws.nrows):
		genMPID = (ws.cell(row, 0).value)
		if type(genMPID) is float or type(genMPID) is int:
			genMPID = str(int(genMPID))
		else:
			genMPID = str(genMPID)
		
		loadMPID = str(ws.cell(row, 1).value)
		if type(loadMPID) is float or type(loadMPID) is int:
			loadMPID = str(int(loadMPID))
		else:
			loadMPID = str(loadMPID)
		
		# if type(mpidName) is float or type(mpidName) is int:
			# mpidName = str(int(mpidName))
		# print assetName
		# raw_input()
		if loadMPID != '':
			# enable_print()
			# print ws.cell(row, 2).value
			# raw_input()
			bus = ws.cell(row, 2).value
			print type(bus)
			bus = int(bus)
			print type(bus)
			print bus
			
			# raw_input()
			
			if type(bus) is str:
				bus = int(float(bus))
			elif type(bus) is float:
				bus = int(bus)
			
			# bus = int(str(ws.cell(row, 2).value))
			id = (ws.cell(row, 3).value)
			# print id, type(id)
			if type(id) is  float:
				id = str(int(id))
			elif type(id) is  int:
				id = str(id)
			else: ## type(id) is  unicode:
				id = str(id)
			isdtag = (ws.cell(row, col2num("E")).value)
			# print loadMPID, bus, id
			# raw_input()
			loadMappingList.append(loadmapdata(genMPID, loadMPID, bus, id, isdtag))
	# raw_input()
	return loadMappingList
######################################
####################################

 
def Write(output, mpid, data, caseName, wb, ws, writeStart):
	# wb = xlwt.Workbook()
	# ws = wb.add_sheet("Loss Factors")
	row = writeStart+1
	Header = "MPID Name,Initial Net Flow,Initial System Loss,Working MPID Internal Loss,Net system Loss,Marginal Unit,Final Net Flow,Final System Loss,Working MPID Internal Loss,Net system Loss,Marginal Unit,Loss Factor, MU Mismatch"

	if writeStart == 0:
		for col, value in enumerate(Header.split(",")):
			ws.write(0, col, value)
			# col += col
	
	# col = 0
	# print "MPID", mpid, "row", row 
	# sys.exit()
	# ws.write(row, 0, mpid)
	for col, value in enumerate(Header.split(",")):
		# ws.write(row, col, 'Test')
		ws.write(row, col, data[col])
	
	wb.save(output)
################################################
################################################
###################


#############################
#############################
class meritorderData(object):  ## Updated by SDR 20-Mar-2019
	def __init__(self, time, serial, assetName, relatedImportAsset, assetShortName, Import_Export, blockNumber, flexibility, offerPrice, blockSize, availablePower, dispatchedPower, capabilityMW, totalDisp_eachMPID, P_export, P_import, P_netImportExport, emmoOffer, loadOffer, CriteriaCheckDecision, deductibleNTGLoad, reduceLoadTag, finalNTGLoad,
	P_export_dict, P_import_dict, P_netImportExport_dict, P_prev_netImportExport_dict):
		self.time = time
		self.serial = serial
		self.assetName = assetName
		self.relatedImportAsset = relatedImportAsset
		self.assetShortName = assetShortName
		self.Import_Export = Import_Export
		self.blockNumber = blockNumber
		self.flexibility = flexibility
		self.offerPrice = offerPrice
		self.blockSize = blockSize
		self.availablePower = availablePower
		self.dispatchedPower = dispatchedPower
		self.capabilityMW = capabilityMW
		self.totalDisp_eachMPID = totalDisp_eachMPID
		self.P_export = P_export
		self.P_import = P_import
		self.P_netImportExport = P_netImportExport
		self.emmoOffer = emmoOffer
		self.loadOffer = loadOffer
		self.CriteriaCheckDecision = CriteriaCheckDecision
		self.deductibleNTGLoad = deductibleNTGLoad
		self.reduceLoadTag = reduceLoadTag
		self.finalNTGLoad = finalNTGLoad
		
		self.P_export_dict = P_export_dict
		self.P_import_dict = P_import_dict
		self.P_netImportExport_dict = P_netImportExport_dict
		self.P_prev_netImportExport_dict = P_prev_netImportExport_dict
		
		

def SelectMonthlyEMMO(EMMOFiles, month):
	desiredFile = ''
	for excelFile in EMMOFiles:
		filename = os.path.splitext(os.path.split(excelFile)[1])[0].lower()
		filename = filename.split("_")[2]
		if month.lower() in filename:
			desiredFile = excelFile
		# if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			# desiredFile = excelFile
			
	return desiredFile

class export(object):  ## Updated by SDR
	def __init__(self, mpidName, totalExportMW):
		self.mpidName = mpidName
		self.totalExportMW = totalExportMW

def getLoadMWData(mpidName, loadData):
	loadValue = 0
	# print mpidName
	for eachloadmpidData in loadData:
		# print eachloadmpidData.mpidName
		if eachloadmpidData.mpidName == mpidName:
			loadValue = eachloadmpidData.mwData
			# print loadValue
		# raw_input()
	return loadValue
	
def getLoadPfData(mpidName, PfData):
	pfValue = 0
	# print mpidName
	for eachloadmpidData in PfData:
		# print eachloadmpidData.mpidName
		if eachloadmpidData.mpidName == mpidName:
			pfValue = eachloadmpidData.pfData
			# print pfValue
		# raw_input()
	return pfValue
		
def readMonthlyEMMO(excelFile): ## Updated by SDR
	print "Reading Monthly EMMO ..... "
	wb = xlrd.open_workbook(excelFile)
	sheetName = "EMMO"
	ws = wb.sheet_by_name(sheetName)
	monthlyEMMOList = []
	for row in range(1, ws.nrows):
		# print "VAL :", col2num('A')
		assetName = str(ws.cell(row, col2num('E')).value)
		relatedImportAsset = ""
		P_export = ''
		P_import = ''
		P_netImportExport = ''
		
		
		P_export_dict = dict()
		P_import_dict = dict()
		P_netImportExport_dict = dict()
		
		P_prev_netImportExport_dict = dict()
		
		#### here assetName means MPID Name in Mapping File
		# print assetName
		# raw_input()
		if assetName != 'N/A':
			if assetName == sk_exp:
				relatedImportAsset = sk_imp
			elif assetName == mt_exp:
				relatedImportAsset = mt_imp
			elif assetName == bc_imp:
				relatedImportAsset = bc_imp
			elif assetName == sk_imp:
				relatedImportAsset = sk_imp
			elif assetName == mt_imp:
				relatedImportAsset = mt_imp
			elif assetName == bc_exp:
				relatedImportAsset = bc_imp
			else:
				relatedImportAsset == ""
			time = ws.cell(row, col2num('B')).value
			# # t1 = time.split(":")[0]
			# # t2 = time.split(":")[1]
			# # t3 = time.split(":")[2]
			# # t4 = time.split(":")[3]
			
			# # t2 = str(int(t2) + 1)
			# # t2 = t2.zfill(2)
			
			# # time = t1 + ":" + t2 + ":" + t3 +":" + t4
			# serial = ws.cell(row, col2num('C')).value
			
			serial = ''
			assetShortName = str(ws.cell(row, col2num('D')).value)
			# print assetName, relatedImportAsset, assetShortName
			# if assetName == bc_exp:
				# raw_input()
			
			
			Import_Export = ws.cell(row, col2num('F')).value
			blockNumber = int(ws.cell(row, col2num('G')).value)
			flexibility = int(ws.cell(row, col2num('H')).value)
			# offerPrice = float(ws.cell(row, col2num('I')).value )
			offerPrice = ws.cell(row, col2num('I')).value
			blockSize = int(ws.cell(row, col2num('J')).value)
			
			availablePower = float(ws.cell(row, col2num('K')).value)
			dispatchedPower = float(ws.cell(row, col2num('L')).value)
			capabilityMW = (ws.cell(row, col2num('M')).value)
			
			# if Import_Export == "E":
				# availablePower = -availablePower
				# dispatchedPower = -dispatchedPower
			
			# totalDisp_eachMPID = ws.cell(row, col2num('N')).value
			totalDisp_eachMPID = 0
			emmoOffer = ''  
			loadOffer = '' 
			CriteriaCheckDecision = ''
			deductibleNTGLoad = ''
			reduceLoadTag = ''
			finalNTGLoad = ''
			# print time, serial, assetName, Import_Export, blockNumber, flexibility, offerPrice, blockSize, availablePower, dispatchedPower, capabilityMW, totalDisp_eachMPID
			# raw_input()
			
			monthlyEMMOList.append(meritorderData(time, serial, assetName, relatedImportAsset, assetShortName, Import_Export, blockNumber, flexibility, offerPrice, blockSize, availablePower, dispatchedPower, capabilityMW, totalDisp_eachMPID, P_export, P_import, P_netImportExport, emmoOffer, loadOffer, CriteriaCheckDecision, deductibleNTGLoad, reduceLoadTag, finalNTGLoad, P_export_dict, P_import_dict, P_netImportExport_dict, P_prev_netImportExport_dict))
	return monthlyEMMOList
######################################
		
def createHourlyEMMO(monthlyEMMO, time, currentHourLoad,  currentHourGrossLoadCriteriaCheck, MPIDs):
	print "Creating Hourly EMMO ...."
	currentHourEMMO = []
	currentHourExports = dict()
	serial = 0
	for row in monthlyEMMO:
		if row.time == time:
			currentHourEMMO.append(row)
			serial += 1
			row.serial = serial
	# enable_print()
	# print len(currentHourEMMO)
	# raw_input()
	
	def determineCumulativeDispatchMW(currentHourEMMO):
		for row in currentHourEMMO:
			currentSerial = row.serial
			currentAssetName = row.assetName
			totalDispatch = 0
			for eachrow in currentHourEMMO:
				if eachrow.serial <= currentSerial and eachrow.assetName == currentAssetName : ## and eachrow.Import_Export != "E":
					totalDispatch = totalDispatch + eachrow.availablePower
				
			row.totalDisp_eachMPID = totalDispatch
			
		return currentHourEMMO
		
	
	
	def determineTotalExport(currentHourEMMO):
		exportServices = [bc_exp, sk_exp, mt_exp]
		currentHourExports = dict()
		Total_currentHourExports_MW = 0
		for exportService in exportServices:
			# currentSerial = row.serial
			# currentAssetName = row.assetName
			totalExportMW = 0
			for eachrow in currentHourEMMO:
				if eachrow.Import_Export == "E" and eachrow.assetName == exportService:
					totalExportMW = totalExportMW + eachrow.availablePower
			# currentHourExports.append(export(mpidName, totalExportMW))
			currentHourExports[exportService] = totalExportMW
			Total_currentHourExports_MW += currentHourExports[exportService]
		return currentHourExports, -Total_currentHourExports_MW
	
	
	def processEMMO(currentHourEMMO, currentHourExports):
		# tie_list = [bc_imp, sk_imp, mt_imp]
		
		P_export = dict()
		P_import = dict()
		P_netImportExport = dict()
		P_prev_netImportExport = dict()
		
		P_export[bc] = -currentHourExports[bc_exp]
		P_import[bc] = 0
		P_netImportExport[bc] = P_import[bc] + P_export[bc]
		P_prev_netImportExport[bc] = P_netImportExport[bc]
		
		P_export[sk] = -currentHourExports[sk_exp]
		P_import[sk] = 0
		P_netImportExport[sk] = P_import[sk] + P_export[sk]
		P_prev_netImportExport[sk] = P_netImportExport[sk]
		
		P_export[mt] = -currentHourExports[mt_exp]
		P_import[mt] = 0
		P_netImportExport[mt] = P_import[mt] + P_export[mt]
		P_prev_netImportExport[mt] = P_netImportExport[mt]
		
		
		# print P_export
		# print P_import
		# print P_netImportExport
		# raw_input()
		
		for row in currentHourEMMO:
			# if row.relatedImportAsset == eachTie:
			if row.assetName == bc_imp:
				row.P_export = P_export[bc]
				row.P_import = P_import[bc] + row.availablePower
				row.P_netImportExport = row.P_import + row.P_export
				
				P_export[bc] = row.P_export
				P_import[bc] = row.P_import
				P_prev_netImportExport[bc] = P_netImportExport[bc]
				P_netImportExport[bc] = row.P_netImportExport
				
				
				
			elif row.assetName == bc_exp:
				row.P_export = P_export[bc] + row.availablePower
				row.P_import = P_import[bc]
				row.P_netImportExport = row.P_import + row.P_export
				
				P_export[bc] = row.P_export
				P_import[bc] = row.P_import
				P_prev_netImportExport[bc] = P_netImportExport[bc]
				P_netImportExport[bc] = row.P_netImportExport
				
				
				
			elif row.assetName == sk_imp:
				row.P_export = P_export[sk]
				row.P_import = P_import[sk] + row.availablePower
				row.P_netImportExport = row.P_import + row.P_export
				
				P_export[sk] = row.P_export
				P_import[sk] = row.P_import
				P_prev_netImportExport[sk] = P_netImportExport[sk]
				P_netImportExport[sk] = row.P_netImportExport
				
				
			elif row.assetName == sk_exp:
				row.P_export = P_export[sk] + row.availablePower
				row.P_import = P_import[sk]
				row.P_netImportExport = row.P_import + row.P_export
				
				P_export[sk] = row.P_export
				P_import[sk] = row.P_import
				P_prev_netImportExport[sk] = P_netImportExport[sk]
				P_netImportExport[sk] = row.P_netImportExport
				
				
			elif row.assetName == mt_imp:
				row.P_export = P_export[mt]
				row.P_import = P_import[mt] + row.availablePower
				row.P_netImportExport = row.P_import + row.P_export
				
				P_export[mt] = row.P_export
				P_import[mt] = row.P_import
				P_prev_netImportExport[mt] = P_netImportExport[mt]
				P_netImportExport[mt] = row.P_netImportExport
				
			
			elif row.assetName == mt_exp:
				row.P_export = P_export[mt] + row.availablePower
				row.P_import = P_import[mt]
				row.P_netImportExport = row.P_import + row.P_export
				
				P_export[mt] = row.P_export
				P_import[mt] = row.P_import
				P_prev_netImportExport[mt] = P_netImportExport[mt]
				P_netImportExport[mt] = row.P_netImportExport
				
			row.P_export_dict[bc] = P_export[bc]
			row.P_import_dict[bc] = P_import[bc]
			row.P_netImportExport_dict[bc] = P_netImportExport[bc]
			row.P_prev_netImportExport_dict[bc] = P_prev_netImportExport[bc]
			P_prev_netImportExport[bc] = P_netImportExport[bc]
			
			row.P_export_dict[sk] = P_export[sk]
			row.P_import_dict[sk] = P_import[sk]
			row.P_netImportExport_dict[sk] = P_netImportExport[sk]
			row.P_prev_netImportExport_dict[sk] = P_prev_netImportExport[sk]
			P_prev_netImportExport[sk] = P_netImportExport[sk]
			
			row.P_export_dict[mt] = P_export[mt]
			row.P_import_dict[mt] = P_import[mt]
			row.P_netImportExport_dict[mt] = P_netImportExport[mt]
			row.P_prev_netImportExport_dict[mt] = P_prev_netImportExport[mt]
			P_prev_netImportExport[mt] = P_netImportExport[mt]
			
		return currentHourEMMO
	
	
	def includeOnsiteNetLoad(currentHourEMMO, currentHourLoad, currentHourGrossLoadCriteriaCheck, MPIDs):
		
		for row in currentHourEMMO:
			# print row.assetName
			for MPID in MPIDs:
				# print MPID.mpidName
				# raw_input()
				if row.assetName == MPID.mpidName:
					row.emmoOffer = MPID.emmoOffer
					row.loadOffer = MPID.loadOffer
					# print row.assetName, row.emmoOffer, row.loadOffer
					
					break
			# raw_input("==")
		
		for eachData in currentHourGrossLoadCriteriaCheck:
			foundTag = 0
			if eachData.decision == 'Apply Load Reduction':
				genMPID = eachData.mpidName
				for row in currentHourEMMO:
					if row.assetName == eachData.mpidName and foundTag == 0:
						foundTag = 1
						row.reduceLoadTag = 'Yes'
						mwData = 0
						for MPID in MPIDs:
							if MPID.mpidName == genMPID:
								loadMPIDs = MPID.loadmpids
								for loadMPID in loadMPIDs:
									mwData = mwData + getLoadMWData(loadMPID, currentHourLoad)* MPID.loadDistributionFactor
								break
						row.deductibleNTGLoad = mwData
						row.finalNTGLoad = row.deductibleNTGLoad
						row.CriteriaCheckDecision = eachData.decision
						
						break
					
		# EMMO_Log = open("Log_EMMO.txt", "w")
		# EMMO_Log.write("time	serial	assetName	relatedImportAsset	assetShortName	Import_Export	blockNumber	flexibility	offerPrice	blockSize	availablePower	dispatchedPower	capabilityMW	totalDisp_eachMPID	P_export	P_import	P_netImportExport	emmoOffer	loadOffer	CriteriaCheckDecision	deductibleNTGLoad	reduceLoadTag	finalNTGLoad	P_export_dict[bc]	P_import_dict[bc]	P_netImportExport_dict[bc]	P_prev_netImportExport_dict[bc]	P_export_dict[sk]	P_import_dict[sk]	P_netImportExport_dict[sk]	P_prev_netImportExport_dict[sk]	P_export_dict[mt]	P_import_dict[mt]	P_netImportExport_dict[mt]	P_prev_netImportExport_dict[mt]")
		# for mUnit in currentHourEMMO:
			# # print mUnit.time, mUnit.serial, mUnit.assetName, mUnit.relatedImportAsset, mUnit.assetShortName, mUnit.Import_Export, mUnit.blockNumber, mUnit.flexibility, mUnit.offerPrice, mUnit.blockSize, mUnit.availablePower, mUnit.dispatchedPower, mUnit.capabilityMW, mUnit.totalDisp_eachMPID, mUnit.P_export, mUnit.P_import, mUnit.P_netImportExport
			
			# EMMO_Log.write("\n")
			# EMMO_Log.write("%s\t"*35 %(mUnit.time, mUnit.serial, mUnit.assetName, mUnit.relatedImportAsset, mUnit.assetShortName, mUnit.Import_Export, mUnit.blockNumber, mUnit.flexibility, mUnit.offerPrice, mUnit.blockSize, mUnit.availablePower, mUnit.dispatchedPower, mUnit.capabilityMW, mUnit.totalDisp_eachMPID, mUnit.P_export, mUnit.P_import, mUnit.P_netImportExport, mUnit.emmoOffer, mUnit.loadOffer, mUnit.CriteriaCheckDecision, mUnit.deductibleNTGLoad, mUnit.reduceLoadTag, mUnit.finalNTGLoad, 
			# mUnit.P_export_dict[bc], mUnit.P_import_dict[bc], mUnit.P_netImportExport_dict[bc], mUnit.P_prev_netImportExport_dict[bc], 
			# mUnit.P_export_dict[sk], mUnit.P_import_dict[sk], mUnit.P_netImportExport_dict[sk], mUnit.P_prev_netImportExport_dict[sk], 
			# mUnit.P_export_dict[mt], mUnit.P_import_dict[mt], mUnit.P_netImportExport_dict[mt], mUnit.P_prev_netImportExport_dict[mt]))
			# # EMMO_Log.write("\n")
						
		# EMMO_Log.close()
		# raw_input("====================================")
		return currentHourEMMO
	
	if len(currentHourEMMO) != 0:
		# print "Processing EMMO .... "
		# raw_input("Check")
		# currentHourEMMO = determineMPIDTotalDispatch(currentHourEMMO)
		currentHourEMMO = determineCumulativeDispatchMW(currentHourEMMO)
		currentHourExports, Total_currentHourExports_MW = determineTotalExport(currentHourEMMO)
		
		for key in currentHourExports.keys():
			print currentHourExports[key]
		# raw_input()
		
		currentHourEMMO = processEMMO(currentHourEMMO, currentHourExports)
		currentHourEMMO = includeOnsiteNetLoad(currentHourEMMO, currentHourLoad,  currentHourGrossLoadCriteriaCheck, MPIDs)
	else:
		print "Missing EMMO ..."
		# raw_input()
		raise MissingDataError("EMMO - In createHourlyEMMO Phase")
		pass
		
	return currentHourEMMO, currentHourExports, Total_currentHourExports_MW
			




######################################
#######################################
def SelectMonthlyLoad(loadDataFiles, month):
	print "Selecting Monthly Load File ... "
	desiredFile = ''
	for excelFile in loadDataFiles:
		filename = os.path.splitext(os.path.split(excelFile)[1])[0].lower()
		filename = filename.split("_")[2]
		if month.lower() in filename:
			desiredFile = excelFile
		# if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			# desiredFile = excelFile
			
	return desiredFile

def SelectMonthlyGrossLoad(grossLoadDataFiles, month):
	print "Selecting Monthly Gross Load File ... "
	desiredFile = ''
	for excelFile in grossLoadDataFiles:
		filename = os.path.splitext(os.path.split(excelFile)[1])[0].lower()
		filename = filename.split("_")[2]
		if month.lower() in filename:
			desiredFile = excelFile
		# if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			# desiredFile = excelFile
			
	return desiredFile

class loadData(object):  ## Updated by SDR
	def __init__(self, mpidName, mwData):
		self.mpidName = mpidName
		self.mwData = mwData
class loadCriteriaCheck(object):  ## Updated by SDR
	def __init__(self, mpidName, decision):
		self.mpidName = mpidName
		self.decision = decision
		
		
def readMonthlyLoad(excelFile):
	print "Reading Monthly Load File ... "
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name("Load (MW)")
	monthlyLoadData = []
	
	times = []
	# enable_print()
	# print ws.ncols
	# raw_input()
	for col in range(col2num('B'), ws.ncols):
		date = (ws.cell(0, col).value)
		# print date
		# raw_input()
		temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
		# print temp.strftime("%d%b%Y:%H:%M:%S")
		
		dt = datetime.timedelta(hours=1)
		time = temp - dt
		time = time.strftime("%d%b%Y:%H:%M:%S")
		time = time.upper()
		# print time
		# raw_input(time)
		# year = temp[0]
		# month = temp[1]
		# day = temp[2]
		
		# hour = str(ws.cell(2, col).value)
		# time = year+month+day+":"+hour
		times.append(time)
	# raw_input("END")
	for row in range(3, ws.nrows):
		mpidName = (ws.cell(row, 0).value)
		# print mpidName, type(mpidName)
		if type(mpidName) is float or type(mpidName) is int:
			mpidName = str(int(mpidName))
		else:
			mpidName = str(mpidName)
		# if type(mpidName) is int:
			# mpidName = str(int(mpidName))
			
		mpidName = mpidName.replace('MP_', '')
		# enable_print()
		# print mpidName, type(mpidName)
		# raw_input()
		mwData = dict()
		# raw_input()
		if mpidName != '':
			for col in range(col2num('B'), ws.ncols):
				k = col2num('B')
				# print row, col, [col-k]
				# print times[col-k]
				mwValue = ws.cell(row, col).value
				if mwValue != '':
					mwData[times[col-k]] = mwValue
				else:
					mwData[times[col-k]] = 0
			# print mpidName, mwData
			monthlyLoadData.append(loadData(mpidName, mwData))
	# raw_input()		
	return monthlyLoadData


	
	
def readMonthlyGrossLoad(excelFile):
	print "Reading Monthly Gross Load File ... "
	wb = xlrd.open_workbook(excelFile)
	# ws = wb.sheet_by_name("Gross Load (MW)")
	ws = wb.sheet_by_name(sheetName_GrossLoadMW)
	ws1 = wb.sheet_by_name("Eligibility Check")
	monthlyGrossLoadData = []
	monthlyCriteriaCheck = []
	
	print "(1) Reading Monthly Gross Load (MW) Data ... "
	times = []
	# enable_print()
	 
	for col in range(col2num('D'), ws.ncols):
		date = (ws.cell(0, col).value)
		# # date_object = datetime.datetime.strptime(date, "%d%b%Y:%H:%M:%S")
		# temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
		# # dt = datetime.timedelta(hours=1)
		# # time = temp - dt
		# time = temp.strftime("%d%b%Y:%H:%M:%S")
		# time = time.upper()
		# time = date.upper()
		temp1 = date.split("/")
		year = temp1[0]
		month = temp1[1]
		month = datetime.datetime.strptime(month, "%m")
		month = month.strftime("%b").upper()
		# print month
		
		temp2 = temp1[2].split(" ")
		day = temp2[0]
		temp3 = temp2[1].split(":")
		hour = temp3[0]
		time = day+month+year+":"+hour+":00:00"
		
		# print time
		# raw_input("END")
		times.append(time)
	# raw_input("END")
	for row in range(1, ws.nrows):
		mpidName = (ws.cell(row, 0).value)
		if type(mpidName) is float or type(mpidName) is int:
			mpidName = str(int(mpidName))
		else:
			mpidName = str(mpidName)
		
		mwData = dict()
		# raw_input()
		if mpidName != '':
			for col in range(col2num('D'), ws.ncols):
				k = col2num('D')
				# print row, col, [col-k]
				# print times[col-k]
				mwValue = ws.cell(row, col).value
				if mwValue != '':
					mwData[times[col-k]] = mwValue
					# print decision[times[col-k]]
					# raw_input()
				else:
					mwData[times[col-k]] = 0
			# print mpidName, mwValue
			monthlyGrossLoadData.append(loadData(mpidName, mwData))
	
	print "(2) Reading Monthly Gross Load - Criteria Check Decisions ... "
	times = []
	for col in range(col2num('D'), ws1.ncols):
		date = (ws1.cell(0, col).value)
		# # date_object = datetime.datetime.strptime(date, "%d%b%Y:%H:%M:%S")
		# temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
		# # dt = datetime.timedelta(hours=1)
		# # time = temp - dt
		# time = temp.strftime("%d%b%Y:%H:%M:%S")
		# time = time.upper()
		# time = date.upper()
		temp1 = date.split("/")
		year = temp1[0]
		month = temp1[1]
		month = datetime.datetime.strptime(month, "%m")
		month = month.strftime("%b").upper()
		# print month
		
		temp2 = temp1[2].split(" ")
		day = temp2[0]
		temp3 = temp2[1].split(":")
		hour = temp3[0]
		time = day+month+year+":"+hour+":00:00"
		
		# print time
		# raw_input("END")
		times.append(time)
	# raw_input("END")
	for row in range(1, ws1.nrows):
		mpidName = (ws1.cell(row, 0).value)
		if type(mpidName) is float or type(mpidName) is int:
			mpidName = str(int(mpidName))
		else:
			mpidName = str(mpidName)
		
		decision = dict()
		# raw_input()
		if mpidName != '':
			for col in range(col2num('D'), ws1.ncols):
				k = col2num('D')
				# print row, col, [col-k]
				# print times[col-k]
				decision_Value = (ws1.cell(row, col).value)
				if decision_Value != '':
					decision[times[col-k]] = str(decision_Value)
					# print mwData[times[col-k]]
					# raw_input()
				else:
					decision[times[col-k]] = ''
			# print mpidName, decision_Value
			monthlyCriteriaCheck.append(loadCriteriaCheck(mpidName, decision))
	return monthlyGrossLoadData, monthlyCriteriaCheck

	
def createHourlyLoad(monthlyLoad, time):
	print "Creating Hourly Load (MW) Data ... "
	currentHourLoad = []
	if len(monthlyLoad) == 0:
		raise MissingDataError("Load (MW) Data - In createHourlyLoad Phase")
	for row in monthlyLoad:
		mpidName = row.mpidName
		# print row.mpidName
		# # raw_input()
		# print row.mwData.keys()
		# raw_input()
		if time in row.mwData.keys():
			mwData = row.mwData[time]
			
		else:
			raise MissingDataError("Load (MW) Data - In createHourlyLoad Phase")
		# print mpidName, mwData
		# raw_input()
		currentHourLoad.append(loadData(mpidName, mwData))
	
	# if len(currentHourLoad) == 0:
		# raise MissingDataError("Load Data")
	
	
	return currentHourLoad
#############################################
	
	
	
def createHourlyGrossLoad(monthlyLoad, time):
	print "Creating Hourly Gross Load (MW) Data ... "
	currentHourGrossLoad = []
	# enable_print()
	
	if len(monthlyLoad) == 0:
		raise MissingDataError("Gross Load (MW) Error")
	for row in monthlyLoad:
		mpidName = row.mpidName
		# print row.mpidName
		# print row.mwData.keys()
		if time in row.mwData.keys():
			mwData = row.mwData[time]
		else:
			raise MissingDataError("Gross Load (MW) Error")
		
		currentHourGrossLoad.append(loadData(mpidName, mwData))
	
	# if len(currentHourLoad) == 0:
		# raise MissingDataError("Load Data")

	return currentHourGrossLoad

def createHourlyGrossLoadCriteriaCheck(monthlyLoad, time):  
	print "Creating Hourly Gross Load Criteria Check Decisions ... "
	currentHourGrossLoadCriteriaCheck = []
	# enable_print()
	
	if len(monthlyLoad) == 0:
		raise MissingDataError("Gross Load Criteria Check -  Error")
	for row in monthlyLoad:
		mpidName = row.mpidName
		# print row.mpidName
		# print row.mwData.keys()
		if time in row.decision.keys():
			decision = row.decision[time]
		else:
			raise MissingDataError("Gross Load Criteria Check -  Error")
		
		currentHourGrossLoadCriteriaCheck.append(loadCriteriaCheck(mpidName, decision))
	
	# if len(currentHourLoad) == 0:
		# raise MissingDataError("Load Data")

	return currentHourGrossLoadCriteriaCheck
	
	
	
#############################################

class loadMvarData(object):  ## Updated by SDR
	def __init__(self, mpidName, mvarDataTag, mvarData):
		self.mpidName = mpidName
		self.mvarDataTag = mvarDataTag
		self.mvarData = mvarData
		self.pfData = mvarData ### Sinc Mvar data saved in the load data (P.F sheet) is actually PF data not MVar
		### self.pfData and self.mvarData both refers to PF data
	
def readMonthly_MvarLoad(excelFile):
	wb = xlrd.open_workbook(excelFile)
	# ws = wb.sheet_by_name("Load MVAR")
	ws = wb.sheet_by_name("PF")
	monthlyLoadData = []
	
	times = []
	for col in range(col2num('C'), ws.ncols):
		date = (ws.cell(0, col).value)
		temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
		dt = datetime.timedelta(hours=1)
		time = temp - dt
		time = time.strftime("%d%b%Y:%H:%M:%S")
		time = time.upper()
		# print time
		# raw_input(time)
		# year = temp[0]
		# month = temp[1]
		# day = temp[2]
		# hour = str(ws.cell(2, col).value)
		# time = year+month+day+":"+hour
		times.append(time)
	# raw_input("END")
	for row in range(3, ws.nrows):
		mpidName = (ws.cell(row, 0).value)
		if type(mpidName) is float or type(mpidName) is int:
			mpidName = str(int(mpidName))
		else:
			mpidName = str(mpidName)
		mpidName = mpidName.replace('MP_', '')
		# enable_print()
		# print mpidName
		# raw_input()
		mvarDataTag = str(ws.cell(row, col2num('B')).value)
		mvarData = dict()
		# raw_input()
		if mpidName != '':
			for col in range(col2num('C'), ws.ncols):
				k = col2num('C')
				# print row, col, [col-k]
				# print times[col-k]
				mvarValue = ws.cell(row, col).value
				if mvarValue != '':
					mvarData[times[col-k]] = ws.cell(row, col).value
				else:
					mvarData[times[col-k]] = 0
			# print mpidName, mwData
			monthlyLoadData.append(loadMvarData(mpidName, mvarDataTag, mvarData))
	# raw_input()		
	return monthlyLoadData

def createHourlyMvarLoad(monthlyMvarLoad, time):
	currentHourMvarLoad = []
	# enable_print()
	if len(monthlyMvarLoad) == 0:
		raise MissingDataError("P.F. Data")
	
	for row in monthlyMvarLoad:
		mpidName = row.mpidName
		mvarDataTag = row.mvarDataTag
		
		if time in row.mvarData.keys():
			mvarData = row.mvarData[time]
		else:
			raise MissingDataError("P.F. Data")
		
		currentHourMvarLoad.append(loadMvarData(mpidName, mvarDataTag, mvarData))
		
	return currentHourMvarLoad

##################################
###################


def SelectMonthlyTSS(tssDataFiles, month):
	desiredFile = ''
	for excelFile in tssDataFiles:
		filename = os.path.splitext(os.path.split(excelFile)[1])[0].lower()
		filename = filename.split("_")[2]
		if month.lower() in filename:
			desiredFile = excelFile
		# if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			# desiredFile = excelFile
			
	return desiredFile

class tssData(object):  ## Updated by SDR
	def __init__(self, mpidName, mwData):
		self.mpidName = mpidName
		self.mwData = mwData

def readMonthlyTSS(excelFile):
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name("TSS")
	monthlyTSSData = []
	
	times = []
	for col in range(col2num('C'), ws.ncols):
	# for col in range(col2num('C'), col2num('AB')):
		date = str(ws.cell(0, col).value)
		if date != "":
			date = (ws.cell(0, col).value)
			temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
			time = temp.strftime("%d%b%Y:%H:%M:%S")
			time = time.upper()
			
			# print time
			# hour = int(ws.cell(1, col).value)
			# hour = str(hour)
			# hour = hour.zfill(2)
			
			# print date, hour
			# raw_input()
			# # # hour = (ws.cell(1, col).value).strip(" ")
			# temp = date.split("-")
			# yr = temp[0]
			# month = temp[1]
			# day = temp[2]
			# dt = yr+"-"+month+"-"+day+"-"+hour
			
			
			# date_time = datetime.datetime.strptime(dt, "%Y-%m-%d-%H")
			# # temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
			# time = date_time.strftime("%d%b%Y:%H:%M:%S")
			# time = time.upper()
			# print time
			# # raw_input(time)
			times.append(time)
	
	# raw_input("END-----")
	
	for row in range(2, ws.nrows):
		mpidName = str(ws.cell(row, 1).value)
		isdtag = str(ws.cell(row, 0).value)
		# mpidName = mpidName.replace('MP_', '')
		mwData = dict()
		# if mpidName != '' and (isdtag == 'ISD' or isdtag == 'ISD-New'):
		if mpidName != '' :
			for col in range(col2num('C'), ws.ncols):
				k = col2num('C')
				# print row, col, [col-k]
				# print mpidName, times[col-k], ws.cell(row, col).value
				mwValue = ws.cell(row, col).value
				if mwValue != '':
					mwData[times[col-k]] = ws.cell(row, col).value
				else:
					mwData[times[col-k]] = 0
			# print mpidName, mwData
				monthlyTSSData.append(tssData(mpidName, mwData))
	# raw_input()		
	return monthlyTSSData

	
def createHourlyTSS(monthlyTSS, time):
	currentHourTSS = []
	# enable_print()
	
	if len(monthlyTSS) == 0:
		raise MissingDataError("TSS Data")
	
	for row in monthlyTSS:
		mpidName = row.mpidName
		
		if time in row.mwData.keys():
			mwData = row.mwData[time]
		else:
			raise MissingDataError("TSS Data")
		
		currentHourTSS.append(tssData(mpidName, mwData))
		
	
		
	return currentHourTSS

################################
######################################
####################
def file_list_(source_path, ext):
	eu = ext.upper()
	base_names = [s for s in os.listdir(source_path) if s.upper().endswith(eu)]
	abs_paths = [os.path.abspath(os.path.join(source_path, s)) for s in base_names]
	return base_names, abs_paths

def ensure_dir(f):
	try:
		os.makedirs(f)
	except OSError:
		if not os.path.isdir(f):
			raise
			
def log_print(log):
	# print "Disabling Screen Out....."
	sys.stdout = log
def enable_print():
	sys.stdout = sys.__stdout__

def remove_duplicates(values):
	output = []
	seen = set()
	for value in values:
		# If value has not been encountered yet,
		# ... add it to both list and set.
		if value not in seen:
			output.append(value)
			seen.add(value)
	return output
	
def progress(toPrint, printVal):
	# time.sleep(1)
	sys.stdout.write("\r%s : %s" %(toPrint,printVal))
	sys.stdout.flush()	
	
# def ilf_main(caseFiles, GenMappingFiles, EMMOFiles, loadDataFiles, loadMappingFiles, tssDataFiles, dates, months):
# def ilf_main(dates, months):
def ilf_main(dates, months, year, inputdir, Selected_Lf_Process, manualTopologyCaseFile):

	enable_print()
	# psspy.psseinit(100000)

	global flowTolerance
	global roundingdecimalpoint
	global iterationLimit
	iterationLimit = 50
	flowTolerance = 0.005
	roundingdecimalpoint = 2
	
	global ab_bc, ab_bc_swingbus
	# ab_bc = [[329, 819, '87'], [232, 1501, '86'], [456, 90000, '01']]
	ab_bc = [[819, 329, '87'], [1501, 232, '86'], [90000, 456, '01']]
	ab_bc_swingbus = 1520
	
	global skTie_bus
	global skTie_loadId
	skTie_bus = 1473
	skTie_loadId = '34'
	
	global mtTie_genbus
	global mtTie_genId
	mtTie_genbus = 80000
	mtTie_genId = "1"
	
	global sk_exp
	global bc_exp
	global mt_exp
	global sk_imp
	global bc_imp
	global mt_imp
	global sk
	global bc
	global mt
	global Import_Export_Services
	
	sk_exp = "SPCEXP"
	bc_exp = "BCHEXP"
	mt_exp = "MTEXP"
	sk_imp = "SPCIMP"
	bc_imp = "BCHIMP"
	mt_imp = "120SIMP"
	sk = 'SK'
	bc = 'AB-BC'
	mt = 'MT'
	
	Import_Export_Services = [bc_imp, mt_imp, sk_imp, bc_exp, mt_exp, sk_exp]
	global sheetName_GrossLoadMW
	sheetName_GrossLoadMW = "Gross Load MW"
	# inputdir = r"C:\Users\sdr\Desktop\ilf\Input Files"
	inputdir = str(inputdir)
	
	dir_case = os.path.join(inputdir, 'Cases')
	dir_emmo = os.path.join(inputdir, 'EMMO')
	# dir_genMapping = os.path.join(inputdir, 'Gen Mapping')
	dir_genMapping = os.path.join(inputdir, 'Mapping Information')
	# dir_loadMapping = os.path.join(inputdir, 'Load Mapping')
	dir_tssData = os.path.join(inputdir, 'TSS Data')
	dir_loadData = os.path.join(inputdir, 'Load Data')
	dir_grossloadData = os.path.join(inputdir, 'Gross Load Data')
	
	# dir_case = os.path.join(os.getcwd(), 'Input Files\\Cases')
	# dir_emmo = os.path.join(os.getcwd(), 'Input Files\\EMMO')
	# dir_genMapping = os.path.join(os.getcwd(), 'Input Files\\Gen Mapping')
	# dir_loadMapping = os.path.join(os.getcwd(), 'Input Files\\Load Mapping')
	# dir_tssData = os.path.join(os.getcwd(), 'Input Files\\TSS Data')
	# dir_loadData = os.path.join(os.getcwd(), 'Input Files\\Load Data')
	
	fullMonths = []
	for date in dates:
		fullMonths.append(date.strftime("%B"))
	fullMonths = remove_duplicates(fullMonths)
	
	if Selected_Lf_Process == "Forecast":
		year_historical = year - 2
	else:
		year_historical = year
	
	
	# year = 2015
	# print fullMonths
	# raw_input()
	
	GenMappingFiles = []
	EMMOFiles = []
	caseFiles = []
	loadDataFiles = []
	loadMappingFiles = []
	tssDataFiles = []
	grossLoadDataFiles = []
	
	
	for each in fullMonths:
		GenMappingFile = os.path.join(dir_genMapping, '%sLF_Mapping Information_%s.xlsx' %(year,each))
		if os.path.isfile(GenMappingFile):
			GenMappingFiles.append(GenMappingFile)
		else:
			print "\nERROR ---- File Missing : ", GenMappingFile
			raise 
		
		EMMOFile = os.path.join(dir_emmo, '%sLF_EMMO_%s.xlsx' %(year,each))
		if os.path.isfile(EMMOFile):
			EMMOFiles.append(EMMOFile)
		else:
			print "\nERROR ---- File Missing : ", EMMOFile
			raise
		
		caseFile = os.path.join(dir_case,"%sLF_%s_R1_Final_Topology.sav" %(year,each))
		if os.path.isfile(caseFile):
			caseFiles.append(caseFile)
		else:
			print "\nERROR ---- File Missing : ", caseFile
			raise
		
		loadDataFile = os.path.join(dir_loadData, '%sLF_Load Data_%s.xlsx' %(year,each))
		if os.path.isfile(loadDataFile):
			loadDataFiles.append(loadDataFile)
		else:
			print "\nERROR ---- File Missing : ", loadDataFile
			raise
		
		tssDataFile = os.path.join(dir_tssData, '%sLF_TSS Volumes_%s.xlsx' %(year_historical,each))
		if os.path.isfile(tssDataFile):
			tssDataFiles.append(tssDataFile)
		else:
			print "\nERROR ---- File Missing : ", tssDataFile
			raise
		
		grossLoadDataFile = os.path.join(dir_grossloadData, '%sLF_Gross Load_%s.xlsx' %(year,each))
		if os.path.isfile(grossLoadDataFile):
			grossLoadDataFiles.append(grossLoadDataFile)
		else:
			print "\nERROR ---- File Missing : ", grossLoadDataFile
			raise
		
	print "========================================"
	print "Input Files : \n"
	
	print "\ncaseFiles : "
	print caseFiles
	
	print "\nMappingFiles : ", 
	print GenMappingFiles
	
	print "\nEMMOFiles : "
	print EMMOFiles
	
	print "\nloadDataFiles : "
	print loadDataFiles
	
	print "\ntssDataFiles : "
	print tssDataFiles
	
	print "\ngrossLoadDataFiles : "
	print grossLoadDataFiles
	print "================================="
	
	ProcessFiles(caseFiles, GenMappingFiles, EMMOFiles, loadDataFiles, loadMappingFiles, tssDataFiles, grossLoadDataFiles, dates, months, Selected_Lf_Process, manualTopologyCaseFile)
	enable_print()
	
	
	print "++++++++++++++++++++++++++++++++++++ END OF PROGRAM +++++++++++++++++++++++++++++++++++"
